/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.result;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.partitions.ResultSetPartitionId;
import org.apache.hyracks.control.nc.result.Page;
import org.apache.hyracks.control.nc.result.ResultState;

public class ResultMemoryManager {
    private int availableMemory;
    private final Set<Page> availPages;
    private final LeastRecentlyUsedList leastRecentlyUsedList;
    private final Map<ResultSetPartitionId, PartitionNode> resultPartitionNodesMap;
    private static final int FRAME_SIZE = 32768;

    public ResultMemoryManager(int availableMemory) {
        this.availableMemory = availableMemory;
        this.availPages = new HashSet<Page>();
        if (this.availableMemory <= 32768) {
            this.availableMemory = 32768;
        }
        this.leastRecentlyUsedList = new LeastRecentlyUsedList();
        this.resultPartitionNodesMap = new HashMap<ResultSetPartitionId, PartitionNode>();
    }

    public synchronized Page requestPage(ResultSetPartitionId resultSetPartitionId, ResultState resultState) throws HyracksDataException {
        Page page;
        if (this.availPages.isEmpty()) {
            if (this.availableMemory >= 32768) {
                this.availPages.add(new Page(ByteBuffer.allocate(32768)));
                this.availableMemory -= 32768;
                page = this.getAvailablePage();
            } else {
                page = this.evictPage();
            }
        } else {
            page = this.getAvailablePage();
        }
        page.clear();
        PartitionNode pn = this.updateReference(resultSetPartitionId, resultState);
        pn.add(page);
        return page;
    }

    public void pageReferenced(ResultSetPartitionId resultSetPartitionId) {
        this.updateReference(resultSetPartitionId, null);
    }

    public static int getPageSize() {
        return 32768;
    }

    protected void insertPartitionNode(ResultSetPartitionId resultSetPartitionId, PartitionNode pn) {
        this.leastRecentlyUsedList.add(pn);
        this.resultPartitionNodesMap.put(resultSetPartitionId, pn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PartitionNode updateReference(ResultSetPartitionId resultSetPartitionId, ResultState resultState) {
        PartitionNode pn = null;
        if (!this.resultPartitionNodesMap.containsKey(resultSetPartitionId)) {
            if (resultState != null) {
                pn = new PartitionNode(resultSetPartitionId, resultState);
                this.insertPartitionNode(resultSetPartitionId, pn);
            }
            return pn;
        }
        ResultMemoryManager resultMemoryManager = this;
        synchronized (resultMemoryManager) {
            pn = this.resultPartitionNodesMap.get(resultSetPartitionId);
            this.leastRecentlyUsedList.remove(pn);
            this.insertPartitionNode(resultSetPartitionId, pn);
        }
        return pn;
    }

    protected Page evictPage() throws HyracksDataException {
        PartitionNode pn = this.leastRecentlyUsedList.getFirst();
        ResultState resultState = pn.getResultState();
        Page page = resultState.returnPage();
        if (page == null) {
            this.availPages.addAll(pn);
            pn.clear();
            this.resultPartitionNodesMap.remove(pn.getResultSetPartitionId());
            this.leastRecentlyUsedList.remove(pn);
            page = this.getAvailablePage();
        } else {
            pn.remove(page);
            if (pn.isEmpty()) {
                this.resultPartitionNodesMap.remove(pn.getResultSetPartitionId());
                this.leastRecentlyUsedList.remove(pn);
            }
        }
        return page;
    }

    protected Page getAvailablePage() {
        Iterator<Page> iter = this.availPages.iterator();
        Page page = iter.next();
        iter.remove();
        return page;
    }

    private class LeastRecentlyUsedList {
        private PartitionNode head = null;
        private PartitionNode tail = null;

        public void add(PartitionNode node) {
            if (this.head == null) {
                this.head = this.tail = node;
                return;
            }
            this.tail.setNext(node);
            node.setPrev(this.tail);
            this.tail = node;
        }

        public void remove(PartitionNode node) {
            if (node == this.head && node == this.tail) {
                this.tail = null;
                this.head = null;
                return;
            }
            if (node == this.head) {
                this.head = this.head.getNext();
                this.head.setPrev(null);
                return;
            }
            if (node == this.tail) {
                this.tail = this.tail.getPrev();
                this.tail.setNext(null);
                return;
            }
            PartitionNode prev = node.getPrev();
            PartitionNode next = node.getNext();
            prev.setNext(next);
            next.setPrev(prev);
        }

        public PartitionNode getFirst() {
            return this.head;
        }
    }

    private class PartitionNode
    extends HashSet<Page> {
        private static final long serialVersionUID = 1L;
        private final ResultSetPartitionId resultSetPartitionId;
        private final ResultState resultState;
        private PartitionNode prev;
        private PartitionNode next;

        public PartitionNode(ResultSetPartitionId resultSetPartitionId, ResultState resultState) {
            this.resultSetPartitionId = resultSetPartitionId;
            this.resultState = resultState;
            this.prev = null;
            this.next = null;
        }

        public ResultSetPartitionId getResultSetPartitionId() {
            return this.resultSetPartitionId;
        }

        public ResultState getResultState() {
            return this.resultState;
        }

        public void setPrev(PartitionNode node) {
            this.prev = node;
        }

        public PartitionNode getPrev() {
            return this.prev;
        }

        public void setNext(PartitionNode node) {
            this.next = node;
        }

        public PartitionNode getNext() {
            return this.next;
        }
    }
}

