/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.constraints.IConstraintAcceptor;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;

public abstract class AbstractConnectorDescriptor
implements IConnectorDescriptor {
    private static final long serialVersionUID = 1L;
    protected ConnectorDescriptorId id;
    protected String displayName;

    public AbstractConnectorDescriptor(IConnectorDescriptorRegistry spec) {
        this.id = spec.createConnectorDescriptor((IConnectorDescriptor)this);
        this.displayName = this.getClass().getName() + "[" + this.id + "]";
    }

    public ConnectorDescriptorId getConnectorId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public JsonNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode jconn = om.createObjectNode();
        jconn.put("id", String.valueOf(this.getConnectorId()));
        jconn.put("java-class", this.getClass().getName());
        jconn.put("display-name", this.displayName);
        return jconn;
    }

    public void contributeSchedulingConstraints(IConstraintAcceptor constraintAcceptor, ActivityCluster ac, ICCServiceContext serviceCtx) {
    }

    public void setConnectorId(ConnectorDescriptorId id) {
        this.id = id;
    }
}

