/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class NodeGroupTupleTranslator
extends AbstractTupleTranslator<NodeGroup> {
    private static final int NODEGROUP_PAYLOAD_TUPLE_FIELD_INDEX = 1;
    protected UnorderedListBuilder listBuilder;
    protected ArrayBackedValueStorage itemValue;

    protected NodeGroupTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.NODEGROUP_DATASET, 1);
        if (getTuple) {
            this.listBuilder = new UnorderedListBuilder();
            this.itemValue = new ArrayBackedValueStorage();
        }
    }

    @Override
    protected NodeGroup createMetadataEntityFromARecord(ARecord nodeGroupRecord) {
        String gpName = ((AString)nodeGroupRecord.getValueByPos(0)).getStringValue();
        IACursor cursor = ((AUnorderedList)nodeGroupRecord.getValueByPos(1)).getCursor();
        ArrayList<String> nodeNames = new ArrayList<String>();
        while (cursor.next()) {
            nodeNames.add(((AString)cursor.get()).getStringValue());
        }
        return new NodeGroup(gpName, nodeNames);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(NodeGroup instance) throws HyracksDataException {
        this.tupleBuilder.reset();
        this.aString.setValue(instance.getNodeGroupName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.NODEGROUP_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(instance.getNodeGroupName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.listBuilder.reset((AbstractCollectionType)((AUnorderedListType)MetadataRecordTypes.NODEGROUP_RECORDTYPE.getFieldTypes()[1]));
        List<String> nodeNames = instance.getNodeNames();
        for (String nodeName : nodeNames) {
            this.itemValue.reset();
            this.aString.setValue(nodeName);
            this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
            this.listBuilder.addItem((IValueReference)this.itemValue);
        }
        this.fieldValue.reset();
        this.listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

