/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.rules.typecast.StaticTypeCastUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceStaticTypeCastForInsertRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        DelegateOperator eOp;
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue());
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        ArrayList producedVariables = new ArrayList();
        if (op1.getOperatorTag() != LogicalOperatorTag.DELEGATE_OPERATOR && op1.getOperatorTag() != LogicalOperatorTag.SINK) {
            return false;
        }
        if (op1.getOperatorTag() == LogicalOperatorTag.DELEGATE_OPERATOR && !((eOp = (DelegateOperator)op1).getDelegate() instanceof CommitOperator)) {
            return false;
        }
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)op1.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.INSERT_DELETE_UPSERT) {
            return false;
        }
        InsertDeleteUpsertOperator insertDeleteOp = (InsertDeleteUpsertOperator)op2;
        if (insertDeleteOp.getOperation() == InsertDeleteUpsertOperator.Kind.DELETE) {
            return false;
        }
        InsertDeleteUpsertOperator insertDeleteOperator = (InsertDeleteUpsertOperator)op2;
        DataSource dataSource = (DataSource)insertDeleteOperator.getDataSource();
        IAType requiredRecordType = dataSource.getItemType();
        ArrayList usedVariables = new ArrayList();
        ((ILogicalExpression)insertDeleteOperator.getPayloadExpression().getValue()).getUsedVariables(usedVariables);
        if (usedVariables.size() == 0) {
            return false;
        }
        LogicalVariable oldRecordVariable = (LogicalVariable)usedVariables.get(0);
        LogicalVariable inputRecordVar = (LogicalVariable)usedVariables.get(0);
        IVariableTypeEnvironment env = insertDeleteOperator.computeOutputTypeEnvironment((ITypingContext)context);
        IAType inputRecordType = (IAType)env.getVarType(inputRecordVar);
        AbstractLogicalOperator currentOperator = (AbstractLogicalOperator)((Mutable)op2.getInputs().get(0)).getValue();
        do {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)currentOperator);
            if (currentOperator.getOperatorTag() != LogicalOperatorTag.ASSIGN) continue;
            AssignOperator assignOp = (AssignOperator)currentOperator;
            producedVariables.clear();
            VariableUtilities.getProducedVariables((ILogicalOperator)currentOperator, producedVariables);
            int position = producedVariables.indexOf(oldRecordVariable);
            if (position < 0) continue;
            AssignOperator originalAssign = (AssignOperator)currentOperator;
            List expressionRefs = originalAssign.getExpressions();
            ILogicalExpression expr = (ILogicalExpression)((Mutable)expressionRefs.get(position)).getValue();
            if (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
                if (TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)funcExpr) != null) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
                    return false;
                }
                IVariableTypeEnvironment assignEnv = assignOp.computeOutputTypeEnvironment((ITypingContext)context);
                StaticTypeCastUtil.rewriteFuncExpr(funcExpr, requiredRecordType, inputRecordType, assignEnv);
            }
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)originalAssign);
        } while (currentOperator.getInputs().size() > 0 && (currentOperator = (AbstractLogicalOperator)((Mutable)currentOperator.getInputs().get(0)).getValue()) != null);
        return true;
    }
}

