/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.optimizer.base.AsterixOptimizationContext;
import org.apache.asterix.optimizer.rules.pushdown.OperatorValueAccessPushdownVisitor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushValueAccessToExternalDataScanRule
implements IAlgebraicRewriteRule {
    private boolean run = true;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (!context.getPhysicalOptimizationConfig().isExternalFieldPushdown() || !this.run) {
            return false;
        }
        this.run = this.shouldRun(context);
        if (this.run) {
            this.run = false;
            OperatorValueAccessPushdownVisitor visitor = new OperatorValueAccessPushdownVisitor(context);
            ((ILogicalOperator)opRef.getValue()).accept((ILogicalOperatorVisitor)visitor, null);
            visitor.finish();
        }
        return false;
    }

    private boolean shouldRun(IOptimizationContext context) throws AlgebricksException {
        ObjectSet entrySet = ((AsterixOptimizationContext)context).getDataSourceMap().int2ObjectEntrySet();
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        for (Int2ObjectMap.Entry dataSources : entrySet) {
            for (DataSource dataSource : (Set)dataSources.getValue()) {
                if (!this.supportPushdown(metadataProvider, dataSource)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean supportPushdown(MetadataProvider metadataProvider, DataSource dataSource) throws AlgebricksException {
        String datasetName;
        DataverseName dataverse = dataSource.getId().getDataverseName();
        Dataset dataset = metadataProvider.findDataset(dataverse, datasetName = dataSource.getId().getDatasourceName());
        return dataset != null && dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && ExternalDataUtils.supportsPushdown((Map)((ExternalDatasetDetails)dataset.getDatasetDetails()).getProperties());
    }
}

