/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.hyracks.control.common.work;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SynchronizableWork extends AbstractWork {

    private static final Logger LOGGER = LogManager.getLogger();

    private boolean done;

    private Exception e;

    protected abstract void doRun() throws Exception;

    public void init() {
        done = false;
        e = null;
    }

    @Override
    public final void run() {
        try {
            doRun();
        } catch (Exception ex) {
            LOGGER.log(Level.INFO, "Exception thrown from work", ex);
            this.e = ex;
        } finally {
            synchronized (this) {
                done = true;
                notifyAll();
            }
        }
    }

    public final synchronized void sync() throws Exception {
        while (!done) {
            wait();
        }
        if (e != null) {
            throw e;
        }
    }
}
