/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FeedPolicyTupleTranslator
extends AbstractTupleTranslator<FeedPolicyEntity> {
    private final org.apache.asterix.metadata.bootstrap.FeedPolicyEntity feedPolicyEntity;

    protected FeedPolicyTupleTranslator(boolean getTuple, org.apache.asterix.metadata.bootstrap.FeedPolicyEntity feedPolicyEntity) {
        super(getTuple, feedPolicyEntity.getIndex(), feedPolicyEntity.payloadPosition());
        this.feedPolicyEntity = feedPolicyEntity;
    }

    @Override
    protected FeedPolicyEntity createMetadataEntityFromARecord(ARecord feedPolicyRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)feedPolicyRecord.getValueByPos(this.feedPolicyEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.feedPolicyEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)feedPolicyRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String policyName = ((AString)feedPolicyRecord.getValueByPos(this.feedPolicyEntity.policyNameIndex())).getStringValue();
        String description = ((AString)feedPolicyRecord.getValueByPos(this.feedPolicyEntity.descriptionIndex())).getStringValue();
        IACursor cursor = ((AUnorderedList)feedPolicyRecord.getValueByPos(this.feedPolicyEntity.propertiesIndex())).getCursor();
        HashMap<String, String> policyParamters = new HashMap<String, String>();
        while (cursor.next()) {
            ARecord field = (ARecord)cursor.get();
            String key = ((AString)field.getValueByPos(0)).getStringValue();
            String value = ((AString)field.getValueByPos(1)).getStringValue();
            policyParamters.put(key, value);
        }
        return new FeedPolicyEntity(databaseName, dataverseName, policyName, description, policyParamters);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(FeedPolicyEntity feedPolicy) throws HyracksDataException {
        String dataverseCanonicalName = feedPolicy.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        if (this.feedPolicyEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(feedPolicy.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(feedPolicy.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.feedPolicyEntity.getRecordType());
        if (this.feedPolicyEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(feedPolicy.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.feedPolicyEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedPolicyEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedPolicy.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedPolicyEntity.policyNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedPolicy.getDescription());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedPolicyEntity.descriptionIndex(), (IValueReference)this.fieldValue);
        Map properties = feedPolicy.getProperties();
        UnorderedListBuilder listBuilder = new UnorderedListBuilder();
        listBuilder.reset((AbstractCollectionType)((AUnorderedListType)this.feedPolicyEntity.getRecordType().getFieldTypes()[this.feedPolicyEntity.propertiesIndex()]));
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        for (Map.Entry property : properties.entrySet()) {
            String name = (String)property.getKey();
            String value = (String)property.getValue();
            itemValue.reset();
            this.writePropertyTypeRecord(name, value, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(this.feedPolicyEntity.propertiesIndex(), (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    private void writePropertyTypeRecord(String name, String value, DataOutput out) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(MetadataRecordTypes.POLICY_PARAMS_RECORDTYPE);
        AMutableString aString = new AMutableString("");
        fieldValue.reset();
        aString.setValue(name);
        this.stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        this.stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        propertyRecordBuilder.write(out, true);
    }
}

