/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.api;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.BloomFilterBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.ChainedLSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.util.ComponentUtils;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;

public abstract class AbstractLSMWithBloomFilterDiskComponent
extends AbstractLSMDiskComponent {
    public AbstractLSMWithBloomFilterDiskComponent(AbstractLSMIndex lsmIndex, IMetadataPageManager mdPageManager, ILSMComponentFilter filter) {
        super(lsmIndex, mdPageManager, filter);
    }

    public abstract BloomFilter getBloomFilter();

    public abstract IBufferCache getBloomFilterBufferCache();

    @Override
    public void markAsValid(boolean persist, IPageWriteFailureCallback callback) throws HyracksDataException {
        ComponentUtils.markAsValid(this.getBloomFilterBufferCache(), this.getBloomFilter(), persist);
        super.markAsValid(persist, callback);
    }

    @Override
    public void activate(boolean createNewComponent) throws HyracksDataException {
        super.activate(createNewComponent);
        if (createNewComponent) {
            this.getBloomFilter().create();
        }
        this.getBloomFilter().activate();
    }

    @Override
    public void destroy() throws HyracksDataException {
        super.destroy();
        this.getBloomFilter().destroy();
    }

    @Override
    public void deactivate() throws HyracksDataException {
        super.deactivate();
        this.getBloomFilter().deactivate();
    }

    @Override
    protected void purge() throws HyracksDataException {
        super.purge();
        this.getBloomFilter().purge();
    }

    public IChainedComponentBulkLoader createBloomFilterBulkLoader(long numElementsHint, IPageWriteCallback callback) throws HyracksDataException {
        BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)BloomCalculations.maxBucketsPerElement((long)numElementsHint), (double)this.getLsmIndex().bloomFilterFalsePositiveRate());
        return new BloomFilterBulkLoader(this.getBloomFilter().createBuilder(numElementsHint, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements(), callback));
    }

    @Override
    public ChainedLSMDiskComponentBulkLoader createBulkLoader(ILSMIOOperation operation, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean withFilter, boolean cleanupEmptyComponent, IPageWriteCallback callback) throws HyracksDataException {
        ChainedLSMDiskComponentBulkLoader chainedBulkLoader = super.createBulkLoader(operation, fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, withFilter, cleanupEmptyComponent, callback);
        if (numElementsHint > 0L) {
            chainedBulkLoader.addBulkLoader(this.createBloomFilterBulkLoader(numElementsHint, callback));
        }
        return chainedBulkLoader;
    }
}

