/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.replication.AllDatasetsReplicationStrategy;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.ReplicationJob;
import org.apache.asterix.common.storage.DatasetCopyIdentifier;
import org.apache.asterix.common.storage.DatasetResourceReference;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.common.storage.ResourceStorageStats;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOBulkOperation;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PersistentLocalResourceRepository
implements ILocalResourceRepository {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String METADATA_FILE_MASK_NAME = ".mask_.metadata";
    private static final FilenameFilter LSM_INDEX_FILES_FILTER = (dir, name) -> name.startsWith(".metadata") || !name.startsWith(".");
    private static final FilenameFilter MASK_FILES_FILTER = (dir, name) -> name.startsWith(".mask_");
    private static final FilenameFilter METADATA_FILES_FILTER = (dir, name) -> name.equals(".metadata");
    private static final FilenameFilter METADATA_MASK_FILES_FILTER = (dir, name) -> name.equals(METADATA_FILE_MASK_NAME);
    private static final int MAX_CACHED_RESOURCES = 1000;
    private final IIOManager ioManager;
    private final Cache<String, LocalResource> resourceCache;
    private boolean isReplicationEnabled = false;
    private IReplicationManager replicationManager;
    private final List<FileReference> storageRoots;
    private final IIndexCheckpointManagerProvider indexCheckpointManagerProvider;
    private final IPersistedResourceRegistry persistedResourceRegistry;
    private final ReentrantReadWriteLock resourcesAccessLock = new ReentrantReadWriteLock(true);
    private IDatasetLifecycleManager datasetLifecycleManager;

    public PersistentLocalResourceRepository(IIOManager ioManager, IIndexCheckpointManagerProvider indexCheckpointManagerProvider, IPersistedResourceRegistry persistedResourceRegistry) {
        this.ioManager = ioManager;
        this.indexCheckpointManagerProvider = indexCheckpointManagerProvider;
        this.persistedResourceRegistry = persistedResourceRegistry;
        this.storageRoots = new ArrayList<FileReference>();
        List ioDevices = ioManager.getIODevices();
        for (int i = 0; i < ioDevices.size(); ++i) {
            this.storageRoots.add(new FileReference((IODeviceHandle)ioDevices.get(i), "storage"));
        }
        this.createStorageRoots();
        this.resourceCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    }

    public String toString() {
        StringBuilder aString = new StringBuilder().append(PersistentLocalResourceRepository.class.getSimpleName()).append(13).append(this.ioManager.getClass().getSimpleName()).append(':').append(13).append(this.ioManager).append(13).append("Cached Resources:").append(13);
        this.resourceCache.asMap().forEach((key, value) -> aString.append((String)key).append("->").append(value).append(13));
        return aString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalResource get(String relativePath) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            FileReference resourceFile;
            LocalResource resource = (LocalResource)this.resourceCache.getIfPresent((Object)relativePath);
            if (resource == null && (resource = this.readLocalResource(resourceFile = PersistentLocalResourceRepository.getLocalResourceFileByName(this.ioManager, relativePath))) != null) {
                this.resourceCache.put((Object)relativePath, (Object)resource);
            }
            LocalResource localResource = resource;
            return localResource;
        }
        finally {
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(LocalResource resource) throws HyracksDataException {
        FileReference resourceFile;
        this.beforeWriteAccess();
        try {
            String relativePath = PersistentLocalResourceRepository.getFileName(resource.getPath());
            resourceFile = this.ioManager.resolve(relativePath);
            if (resourceFile.getFile().exists()) {
                throw new HyracksDataException("Duplicate resource: " + resourceFile.getAbsolutePath());
            }
            FileReference parent = resourceFile.getParent();
            if (!this.ioManager.exists(parent) && !this.ioManager.makeDirectories(parent)) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CREATE_FILE, (Serializable[])new Serializable[]{parent.getAbsolutePath()});
            }
            try {
                this.createResourceFileMask(resourceFile);
                byte[] bytes = OBJECT_MAPPER.writeValueAsBytes((Object)resource.toJson(this.persistedResourceRegistry));
                this.ioManager.overwrite(resourceFile, bytes);
                this.indexCheckpointManagerProvider.get((ResourceReference)DatasetResourceReference.of((LocalResource)resource)).init(-1L, 0L, LSMComponentId.EMPTY_INDEX_LAST_COMPONENT_ID.getMaxId(), null);
                this.deleteResourceFileMask(resourceFile);
            }
            catch (Exception e) {
                this.cleanup(resourceFile);
                throw HyracksDataException.create((Throwable)e);
            }
            catch (Throwable th) {
                LOGGER.error("Error creating resource {}", (Object)resourceFile, (Object)th);
                ExitUtil.halt((int)13);
            }
            this.resourceCache.put((Object)resource.getPath(), (Object)resource);
        }
        finally {
            this.afterWriteAccess();
        }
        if (this.isReplicationEnabled) {
            try {
                this.createReplicationJob(IReplicationJob.ReplicationOperation.REPLICATE, resourceFile);
            }
            catch (Exception e) {
                LOGGER.error("failed to send resource file {} to replicas", (Object)resourceFile);
            }
        }
    }

    private void cleanup(FileReference resourceFile) {
        if (resourceFile.getFile().exists()) {
            try {
                this.ioManager.delete(resourceFile);
            }
            catch (Throwable th) {
                LOGGER.error("Error cleaning up corrupted resource {}", (Object)resourceFile, (Object)th);
                ExitUtil.halt((int)12);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String relativePath) throws HyracksDataException {
        block10: {
            boolean resourceExists;
            FileReference resourceFile = PersistentLocalResourceRepository.getLocalResourceFileByName(this.ioManager, relativePath);
            LocalResource localResource = this.readLocalResource(resourceFile);
            boolean bl = resourceExists = localResource != null;
            if (this.isReplicationEnabled && resourceExists) {
                try {
                    this.createReplicationJob(IReplicationJob.ReplicationOperation.DELETE, resourceFile);
                }
                catch (Exception e) {
                    LOGGER.error("failed to delete resource file {} from replicas", (Object)resourceFile);
                }
            }
            this.beforeWriteAccess();
            try {
                try {
                    if (resourceExists) {
                        this.ioManager.delete(resourceFile);
                        this.indexCheckpointManagerProvider.get((ResourceReference)DatasetResourceReference.of((LocalResource)localResource)).delete();
                        break block10;
                    }
                    throw HyracksDataException.create((ErrorCode)ErrorCode.RESOURCE_DOES_NOT_EXIST, (Serializable[])new Serializable[]{relativePath});
                }
                finally {
                    this.invalidateResource(relativePath);
                }
            }
            finally {
                this.afterWriteAccess();
            }
        }
    }

    public static FileReference getLocalResourceFileByName(IIOManager ioManager, String resourcePath) throws HyracksDataException {
        String fileName = resourcePath + File.separator + ".metadata";
        return ioManager.resolve(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, LocalResource> getResources(Predicate<LocalResource> filter, List<FileReference> roots) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            HashMap<Long, LocalResource> resourcesMap = new HashMap<Long, LocalResource>();
            for (FileReference root : roots) {
                Set files = this.ioManager.list(root, METADATA_FILES_FILTER);
                try {
                    for (FileReference file : files) {
                        LocalResource duplicate;
                        LocalResource localResource = this.readLocalResource(file);
                        if (localResource == null || !filter.test(localResource) || (duplicate = resourcesMap.putIfAbsent(localResource.getId(), localResource)) == null) continue;
                        LOGGER.warn("found duplicate resource ids {} and {}", (Object)localResource, (Object)duplicate);
                    }
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
            HashMap<Long, LocalResource> hashMap = resourcesMap;
            return hashMap;
        }
        finally {
            this.afterReadAccess();
        }
    }

    public Map<Long, LocalResource> getResources(Predicate<LocalResource> filter) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            Map<Long, LocalResource> map = this.getResources(filter, this.storageRoots);
            return map;
        }
        finally {
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, LocalResource> getResources(Predicate<LocalResource> filter, Set<Integer> partitions) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            ArrayList<FileReference> partitionsRoots = new ArrayList<FileReference>();
            for (Integer partition : partitions) {
                partitionsRoots.add(this.getPartitionRoot(partition));
            }
            Map<Long, LocalResource> map = this.getResources(filter, partitionsRoots);
            return map;
        }
        finally {
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInvalidIndexes(Predicate<LocalResource> filter) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            IIOBulkOperation bulkDelete = this.ioManager.createDeleteBulkOperation();
            for (FileReference root : this.storageRoots) {
                Set files = this.ioManager.list(root, METADATA_FILES_FILTER);
                try {
                    for (FileReference file : files) {
                        LocalResource localResource = this.readLocalResource(file);
                        if (localResource == null || !filter.test(localResource)) continue;
                        FileReference parent = file.getParent();
                        LOGGER.warn("deleting invalid metadata index {}", (Object)parent);
                        bulkDelete.add(parent);
                    }
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
            this.ioManager.performBulkOperation(bulkDelete);
            this.resourceCache.invalidateAll();
        }
        finally {
            this.afterReadAccess();
        }
    }

    public Map<Long, LocalResource> loadAndGetAllResources() throws HyracksDataException {
        this.beforeReadAccess();
        try {
            Map<Long, LocalResource> map = this.getResources(p -> true);
            return map;
        }
        finally {
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long maxId() throws HyracksDataException {
        this.beforeReadAccess();
        try {
            Map<Long, LocalResource> allResources = this.loadAndGetAllResources();
            Optional max = allResources.keySet().stream().max(Long::compare);
            long l = max.isPresent() ? (Long)max.get() : 0L;
            return l;
        }
        finally {
            this.afterReadAccess();
        }
    }

    public void invalidateResource(String relativePath) {
        this.resourceCache.invalidate((Object)relativePath);
    }

    public void clearResourcesCache() {
        this.resourceCache.invalidateAll();
    }

    private static String getFileName(String path) {
        return path.endsWith(File.separator) ? path + ".metadata" : path + File.separator + ".metadata";
    }

    private LocalResource readLocalResource(FileReference fileRef) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            byte[] bytes = this.ioManager.readAllBytes(fileRef);
            if (bytes == null) {
                LocalResource localResource = null;
                return localResource;
            }
            JsonNode jsonNode = (JsonNode)OBJECT_MAPPER.readValue(bytes, JsonNode.class);
            LocalResource resource = (LocalResource)this.persistedResourceRegistry.deserialize(jsonNode);
            if (resource.getVersion() == 7) {
                LocalResource localResource = resource;
                return localResource;
            }
            try {
                throw new AsterixException("Storage version mismatch.");
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        finally {
            this.afterReadAccess();
        }
    }

    public void setReplicationManager(IReplicationManager replicationManager) {
        this.beforeWriteAccess();
        try {
            this.replicationManager = replicationManager;
            this.isReplicationEnabled = replicationManager.isReplicationEnabled();
        }
        finally {
            this.afterWriteAccess();
        }
    }

    public void setDatasetLifecycleManager(IDatasetLifecycleManager datasetLifecycleManager) {
        this.datasetLifecycleManager = datasetLifecycleManager;
    }

    private void createReplicationJob(IReplicationJob.ReplicationOperation operation, FileReference fileRef) throws HyracksDataException {
        ReplicationJob job = new ReplicationJob(IReplicationJob.ReplicationJobType.METADATA, operation, IReplicationJob.ReplicationExecutionType.SYNC, Set.of(fileRef.getAbsolutePath()));
        try {
            this.replicationManager.submitJob((IReplicationJob)job);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStorageData() throws HyracksDataException {
        this.beforeWriteAccess();
        try {
            IIOBulkOperation bulkDelete = this.ioManager.createDeleteBulkOperation();
            for (FileReference root : this.storageRoots) {
                bulkDelete.add(root);
            }
            this.ioManager.performBulkOperation(bulkDelete);
            this.createStorageRoots();
        }
        finally {
            this.afterWriteAccess();
        }
    }

    public Set<Integer> getAllPartitions() throws HyracksDataException {
        this.beforeReadAccess();
        try {
            Set<Integer> set = this.loadAndGetAllResources().values().stream().map(LocalResource::getResource).map(DatasetLocalResource.class::cast).map(DatasetLocalResource::getPartition).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<DatasetResourceReference> getLocalResourceReference(String absoluteFilePath) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            String localResourcePath = StoragePathUtil.getIndexFileRelativePath((String)absoluteFilePath);
            LocalResource lr = this.get(localResourcePath);
            Optional<DatasetResourceReference> optional = lr != null ? Optional.of(DatasetResourceReference.of((LocalResource)lr)) : Optional.empty();
            return optional;
        }
        finally {
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileReference> getPartitionIndexes(int partition) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            FileReference partitionRoot = this.getPartitionRoot(partition);
            Map<Long, LocalResource> partitionResourcesMap = this.getResources((LocalResource resource) -> {
                DatasetLocalResource dsResource = (DatasetLocalResource)resource.getResource();
                return dsResource.getPartition() == partition;
            }, Collections.singletonList(partitionRoot));
            HashSet<FileReference> indexes = new HashSet<FileReference>();
            for (LocalResource localResource : partitionResourcesMap.values()) {
                indexes.add(this.ioManager.resolve(localResource.getPath()));
            }
            HashSet<FileReference> hashSet = indexes;
            return hashSet;
        }
        finally {
            this.afterReadAccess();
        }
    }

    public Map<Long, LocalResource> getPartitionResources(int partition) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            Map<Long, LocalResource> map = this.getResources((LocalResource r) -> true, Collections.singleton(partition));
            return map;
        }
        finally {
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getPartitionReplicatedResources(int partition, IReplicationStrategy strategy) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            HashMap<String, Long> partitionReplicatedResources = new HashMap<String, Long>();
            Map<Long, LocalResource> partitionResources = this.getPartitionResources(partition);
            for (LocalResource lr : partitionResources.values()) {
                DatasetLocalResource datasetLocalResource = (DatasetLocalResource)lr.getResource();
                if (!strategy.isMatch(datasetLocalResource.getDatasetId())) continue;
                DatasetResourceReference drr = DatasetResourceReference.of((LocalResource)lr);
                partitionReplicatedResources.put(drr.getFileRelativePath().toString(), lr.getId());
            }
            HashMap<String, Long> hashMap = partitionReplicatedResources;
            return hashMap;
        }
        finally {
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPartitionReplicatedFiles(int partition, IReplicationStrategy strategy) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            ArrayList<String> partitionReplicatedFiles = new ArrayList<String>();
            HashSet<FileReference> replicatedIndexes = new HashSet<FileReference>();
            Map<Long, LocalResource> partitionResources = this.getPartitionResources(partition);
            for (LocalResource lr : partitionResources.values()) {
                DatasetLocalResource datasetLocalResource = (DatasetLocalResource)lr.getResource();
                if (!strategy.isMatch(datasetLocalResource.getDatasetId())) continue;
                replicatedIndexes.add(this.ioManager.resolve(lr.getPath()));
            }
            for (FileReference indexDir : replicatedIndexes) {
                partitionReplicatedFiles.addAll(this.getIndexFiles(indexDir));
            }
            ArrayList<String> arrayList = partitionReplicatedFiles;
            return arrayList;
        }
        finally {
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReplicatedIndexesMaxComponentId(int partition, IReplicationStrategy strategy) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            long maxComponentId = 0L;
            Map<Long, LocalResource> partitionResources = this.getPartitionResources(partition);
            for (LocalResource lr : partitionResources.values()) {
                DatasetLocalResource datasetLocalResource = (DatasetLocalResource)lr.getResource();
                if (!strategy.isMatch(datasetLocalResource.getDatasetId())) continue;
                IIndexCheckpointManager indexCheckpointManager = this.indexCheckpointManagerProvider.get((ResourceReference)DatasetResourceReference.of((LocalResource)lr));
                maxComponentId = Math.max(maxComponentId, indexCheckpointManager.getLatest().getLastComponentId());
            }
            long l = maxComponentId;
            return l;
        }
        finally {
            this.afterReadAccess();
        }
    }

    private List<String> getIndexFiles(FileReference indexDir) throws HyracksDataException {
        ArrayList<String> indexFiles = new ArrayList<String>();
        Set indexFilteredFiles = this.ioManager.list(indexDir, LSM_INDEX_FILES_FILTER);
        indexFilteredFiles.stream().map(FileReference::getAbsolutePath).forEach(indexFiles::add);
        return indexFiles;
    }

    private void createStorageRoots() {
        for (FileReference root : this.storageRoots) {
            this.ioManager.makeDirectories(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(int partition) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            this.datasetLifecycleManager.waitForIO(AllDatasetsReplicationStrategy.INSTANCE, partition);
            Set<FileReference> partitionIndexes = this.getPartitionIndexes(partition);
            try {
                for (FileReference index : partitionIndexes) {
                    this.deleteIndexMaskedFiles(index);
                    if (!this.isValidIndex(index)) continue;
                    this.deleteIndexInvalidComponents(index);
                }
            }
            catch (IOException | ParseException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        finally {
            this.clearResourcesCache();
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceStorageStats> getStorageStats() throws HyracksDataException {
        this.beforeReadAccess();
        try {
            List allResources = this.loadAndGetAllResources().values().stream().map(DatasetResourceReference::of).collect(Collectors.toList());
            ArrayList<ResourceStorageStats> resourcesStats = new ArrayList<ResourceStorageStats>();
            for (DatasetResourceReference res : allResources) {
                ResourceStorageStats resourceStats = this.getResourceStats(res);
                if (resourceStats == null) continue;
                resourcesStats.add(resourceStats);
            }
            ArrayList<ResourceStorageStats> arrayList = resourcesStats;
            return arrayList;
        }
        finally {
            this.afterReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCorruptedResources() throws HyracksDataException {
        this.beforeWriteAccess();
        try {
            IIOBulkOperation bulkDelete = this.ioManager.createDeleteBulkOperation();
            for (FileReference root : this.storageRoots) {
                Set metadataMaskFiles = this.ioManager.list(root, METADATA_MASK_FILES_FILTER);
                for (FileReference metadataMaskFile : metadataMaskFiles) {
                    FileReference resourceFile = metadataMaskFile.getParent().getChild(".metadata");
                    bulkDelete.add(resourceFile);
                    bulkDelete.add(metadataMaskFile);
                }
            }
            this.ioManager.performBulkOperation(bulkDelete);
        }
        finally {
            this.afterWriteAccess();
        }
    }

    private void deleteIndexMaskedFiles(FileReference index) throws IOException {
        IIOBulkOperation bulkDelete = this.ioManager.createDeleteBulkOperation();
        Set masks = this.ioManager.list(index, MASK_FILES_FILTER);
        for (FileReference mask : masks) {
            this.deleteIndexMaskedFiles(index, mask);
            bulkDelete.add(mask);
        }
        this.ioManager.performBulkOperation(bulkDelete);
    }

    private boolean isValidIndex(FileReference index) throws IOException {
        return this.getIndexCheckpointManager(index).getCheckpointCount() != 0;
    }

    private void deleteIndexInvalidComponents(FileReference index) throws IOException, ParseException {
        Set indexComponentFiles = this.ioManager.list(index, AbstractLSMIndexFileManager.COMPONENT_FILES_FILTER);
        if (indexComponentFiles == null) {
            throw new IOException(index + " doesn't exist or an IO error occurred");
        }
        IIOBulkOperation bulkDelete = this.ioManager.createDeleteBulkOperation();
        long validComponentSequence = this.getIndexCheckpointManager(index).getValidComponentSequence();
        for (FileReference componentFileRef : indexComponentFiles) {
            long fileStart = IndexComponentFileReference.of((String)componentFileRef.getName()).getSequenceStart();
            long fileEnd = IndexComponentFileReference.of((String)componentFileRef.getName()).getSequenceEnd();
            if (fileStart <= validComponentSequence && fileEnd <= validComponentSequence) continue;
            LOGGER.warn(() -> "Deleting invalid component file " + componentFileRef.getAbsolutePath() + " based on valid sequence " + validComponentSequence);
            bulkDelete.add(componentFileRef);
        }
        this.ioManager.performBulkOperation(bulkDelete);
    }

    private IIndexCheckpointManager getIndexCheckpointManager(FileReference index) throws HyracksDataException {
        String indexFile = index.getChild(".metadata").getAbsolutePath();
        ResourceReference indexRef = ResourceReference.of((String)indexFile);
        return this.indexCheckpointManagerProvider.get(indexRef);
    }

    private void deleteIndexMaskedFiles(FileReference index, FileReference mask) throws IOException {
        Set maskedFiles;
        if (!mask.getFile().getName().startsWith(".mask_")) {
            throw new IllegalArgumentException("Unrecognized mask file: " + mask);
        }
        if (PersistentLocalResourceRepository.isComponentMask(mask)) {
            String componentId = mask.getName().substring(".mask_C_".length());
            maskedFiles = this.ioManager.list(index, (dir, name) -> name.startsWith(componentId));
        } else {
            String maskedFileName = mask.getName().substring(".mask_".length());
            maskedFiles = this.ioManager.list(index, (dir, name) -> name.equals(maskedFileName));
        }
        if (maskedFiles != null) {
            IIOBulkOperation bulkDelete = this.ioManager.createDeleteBulkOperation();
            for (FileReference maskedFile : maskedFiles) {
                LOGGER.info(() -> "deleting masked file: " + maskedFile.getAbsolutePath());
                bulkDelete.add(maskedFile);
            }
            this.ioManager.performBulkOperation(bulkDelete);
        }
    }

    private ResourceStorageStats getResourceStats(DatasetResourceReference resource) {
        try {
            FileReference resolvedPath = this.ioManager.resolve(resource.getRelativePath().toString());
            long totalSize = 0L;
            Set indexFiles = this.ioManager.list(resolvedPath);
            HashMap<String, Long> componentsStats = new HashMap<String, Long>();
            if (indexFiles != null) {
                for (FileReference file : indexFiles) {
                    long fileSize = this.ioManager.getSize(file);
                    totalSize += fileSize;
                    if (!PersistentLocalResourceRepository.isComponentFile(resolvedPath, file.getName())) continue;
                    String componentSeq = ResourceReference.getComponentSequence((String)file.getAbsolutePath());
                    componentsStats.put(componentSeq, componentsStats.getOrDefault(componentSeq, 0L) + fileSize);
                }
            }
            return new ResourceStorageStats(resource, componentsStats, totalSize);
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't get stats for resource {}", (Object)resource.getRelativePath(), (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDatasetSize(DatasetCopyIdentifier datasetIdentifier, Set<Integer> nodePartitions) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            long totalSize = 0L;
            Map<Long, LocalResource> dataverse = this.getResources((LocalResource lr) -> {
                ResourceReference resourceReference = ResourceReference.ofIndex((String)lr.getPath());
                return datasetIdentifier.isMatch(resourceReference);
            }, nodePartitions);
            List allResources = dataverse.values().stream().map(DatasetResourceReference::of).collect(Collectors.toList());
            for (DatasetResourceReference res : allResources) {
                ResourceStorageStats resourceStats = this.getResourceStats(res);
                if (resourceStats == null) continue;
                totalSize += resourceStats.getTotalSize();
            }
            long l = totalSize;
            return l;
        }
        finally {
            this.afterReadAccess();
        }
    }

    private void createResourceFileMask(FileReference resourceFile) throws HyracksDataException {
        FileReference maskFile = this.getResourceMaskFilePath(resourceFile);
        try {
            this.ioManager.create(maskFile);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void deleteResourceFileMask(FileReference resourceFile) throws HyracksDataException {
        FileReference maskFile = this.getResourceMaskFilePath(resourceFile);
        this.ioManager.delete(maskFile);
    }

    private FileReference getResourceMaskFilePath(FileReference resourceFile) {
        FileReference resourceFileParent = resourceFile.getParent();
        return resourceFileParent.getChild(METADATA_FILE_MASK_NAME);
    }

    private static boolean isComponentMask(FileReference mask) {
        return mask.getName().startsWith(".mask_C_");
    }

    private static boolean isComponentFile(FileReference indexDir, String fileName) {
        return AbstractLSMIndexFileManager.COMPONENT_FILES_FILTER.accept(indexDir.getFile(), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileReference> getOnDiskPartitions() {
        this.beforeReadAccess();
        try {
            ArrayList onDiskPartitions = new ArrayList();
            for (FileReference root : this.storageRoots) {
                onDiskPartitions.addAll(IoUtil.getMatchingChildren((FileReference)root, (dir, name) -> dir != null && dir.isDirectory() && name.startsWith("partition_")));
            }
            ArrayList arrayList = onDiskPartitions;
            return arrayList;
        }
        finally {
            this.afterReadAccess();
        }
    }

    public FileReference getPartitionRoot(int partition) throws HyracksDataException {
        String path = "storage" + File.separator + "partition_" + partition;
        return this.ioManager.resolve(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePartition(int partitionId) throws HyracksDataException {
        this.beforeReadAccess();
        try {
            List<FileReference> onDiskPartitions = this.getOnDiskPartitions();
            IIOBulkOperation bulkDelete = this.ioManager.createDeleteBulkOperation();
            for (FileReference onDiskPartition : onDiskPartitions) {
                int partitionNum = StoragePathUtil.getPartitionNumFromRelativePath((String)onDiskPartition.getAbsolutePath());
                if (partitionNum != partitionId) continue;
                LOGGER.warn("deleting partition {}", (Object)partitionNum);
                bulkDelete.add(onDiskPartition);
                break;
            }
            this.ioManager.performBulkOperation(bulkDelete);
        }
        finally {
            this.afterReadAccess();
        }
    }

    private void beforeWriteAccess() {
        this.resourcesAccessLock.readLock().lock();
    }

    private void afterWriteAccess() {
        this.resourcesAccessLock.readLock().unlock();
    }

    private void beforeReadAccess() {
        this.resourcesAccessLock.writeLock().lock();
    }

    private void afterReadAccess() {
        this.resourcesAccessLock.writeLock().unlock();
    }
}

