/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.BinaryEntry;

public class BinaryHashSet {
    static final int NULL_PTR = -1;
    private static final int PTR_SIZE = 4;
    static final int SLOT_SIZE = 2;
    static final int COUNT_SIZE = 1;
    private static final int ENTRY_HEADER_SIZE = 9;
    private static final int NO_OF_FRAME_LIMIT = 65535;
    private static final int ONE_FRAME_SIZE_LIMIT = 65535;
    private final IBinaryHashFunction hashFunc;
    private final IBinaryComparator cmp;
    private final int[] listHeads;
    private final int frameSize;
    private final List<ByteBuffer> frames = new ArrayList<ByteBuffer>();
    private int currFrameIndex;
    private int nextOff;
    private int size;
    private byte[] refArray;

    public BinaryHashSet(int tableSize, int frameSize, IBinaryHashFunction hashFunc, IBinaryComparator cmp, byte[] refArray) {
        this.listHeads = new int[tableSize];
        if (frameSize > 65535) {
            throw new IllegalStateException("A frame size can't be greater than 65535. Can't continue.");
        }
        this.frameSize = frameSize;
        this.hashFunc = hashFunc;
        this.cmp = cmp;
        this.frames.add(ByteBuffer.allocate(frameSize));
        this.clear();
        this.refArray = refArray;
    }

    public void setRefArray(byte[] refArray) {
        this.refArray = refArray;
    }

    public int put(BinaryEntry key) throws HyracksDataException {
        return this.putFindInternal(key, true, null, false);
    }

    public int find(BinaryEntry key, byte[] keyArray, boolean increaseFoundCount) throws HyracksDataException {
        return this.putFindInternal(key, false, keyArray, increaseFoundCount);
    }

    private int putFindInternal(BinaryEntry key, boolean isInsert, byte[] keyArray, boolean increaseFoundCount) throws HyracksDataException {
        int frameOff;
        ByteBuffer frame;
        int bucket = isInsert ? Math.abs(this.hashFunc.hash(this.refArray, key.getOffset(), key.getLength()) % this.listHeads.length) : Math.abs(this.hashFunc.hash(keyArray, key.getOffset(), key.getLength()) % this.listHeads.length);
        int headPtr = this.listHeads[bucket];
        if (headPtr == -1) {
            if (isInsert) {
                this.listHeads[bucket] = this.appendEntry(key);
                return 0;
            }
            return -1;
        }
        do {
            int frameNum = this.getFrameIndex(headPtr);
            frameOff = this.getFrameOffset(headPtr);
            frame = this.frames.get(frameNum);
            char entryKeyOff = frame.getChar(frameOff);
            char entryKeyLen = frame.getChar(frameOff + 2);
            if (entryKeyLen != key.getLength()) continue;
            if (isInsert) {
                if (this.cmp.compare(this.refArray, (int)entryKeyOff, (int)entryKeyLen, this.refArray, key.getOffset(), key.getLength()) != 0) continue;
                byte entryCount = frame.get(frameOff + 4);
                return entryCount;
            }
            if (this.cmp.compare(this.refArray, (int)entryKeyOff, (int)entryKeyLen, keyArray, key.getOffset(), key.getLength()) != 0) continue;
            int entryCount = frame.get(frameOff + 4);
            if (increaseFoundCount && entryCount < 127) {
                ++entryCount;
            }
            frame.put(frameOff + 4, (byte)entryCount);
            return entryCount;
        } while ((headPtr = frame.getInt(frameOff + 4 + 1)) != -1);
        if (isInsert) {
            int newPtr = this.appendEntry(key);
            frame.putInt(frameOff + 4 + 1, newPtr);
            return 0;
        }
        return -1;
    }

    public int appendEntry(BinaryEntry key) {
        ByteBuffer frame = this.frames.get(this.currFrameIndex);
        int requiredSpace = 9;
        if (this.nextOff + requiredSpace >= this.frameSize) {
            if (requiredSpace > this.frameSize) {
                throw new IllegalStateException("A hash key is greater than the framesize: " + this.frameSize + ". Can't continue.");
            }
            if (this.frames.size() > 65535) {
                throw new IllegalStateException("There can't be more than 65535frames. Can't continue.");
            }
            this.frames.add(ByteBuffer.allocate(this.frameSize));
            ++this.currFrameIndex;
            this.nextOff = 0;
            frame = this.frames.get(this.currFrameIndex);
        }
        this.writeEntryHeader(frame, this.nextOff, key.getOffset(), key.getLength(), 0, -1);
        int entryPtr = this.getEntryPtr(this.currFrameIndex, this.nextOff);
        this.nextOff += requiredSpace;
        ++this.size;
        return entryPtr;
    }

    private void writeEntryHeader(ByteBuffer frame, int targetOff, int keyOff, int keyLen, int keyCount, int ptr) {
        frame.putChar(targetOff, (char)keyOff);
        frame.putChar(targetOff + 2, (char)keyLen);
        frame.put(targetOff + 4, (byte)keyCount);
        frame.putInt(targetOff + 4 + 1, ptr);
    }

    private int getEntryPtr(int frameIndex, int frameOff) {
        return (frameIndex << 16) + frameOff;
    }

    private int getFrameIndex(int ptr) {
        return ptr >> 16;
    }

    private int getFrameOffset(int ptr) {
        return ptr & 0xFFFF;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size > 0;
    }

    public void clear() {
        Arrays.fill(this.listHeads, -1);
        this.currFrameIndex = 0;
        this.nextOff = 0;
        this.size = 0;
        this.refArray = null;
    }

    public void clearFoundCount() {
        boolean resetCount = false;
        for (int currentListHeadIndex = 0; currentListHeadIndex < this.listHeads.length; ++currentListHeadIndex) {
            int frameOff;
            ByteBuffer frame;
            if (this.listHeads[currentListHeadIndex] == -1) continue;
            int headPtr = this.listHeads[currentListHeadIndex];
            do {
                int frameNum = this.getFrameIndex(headPtr);
                frameOff = this.getFrameOffset(headPtr);
                frame = this.frames.get(frameNum);
                frame.put(frameOff + 4, (byte)0);
            } while ((headPtr = frame.getInt(frameOff + 4 + 1)) != -1);
        }
    }
}

