/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.io.ObjectStreamException;
import org.apache.iceberg.transforms.Days;
import org.apache.iceberg.transforms.Months;
import org.apache.iceberg.transforms.SerializationProxies;
import org.apache.iceberg.transforms.TimeTransform;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.transforms.Years;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class Hours<T>
extends TimeTransform<T> {
    private static final Hours<?> INSTANCE = new Hours();

    static <T> Hours<T> get() {
        return INSTANCE;
    }

    @Override
    protected Transform<T, Integer> toEnum(Type type) {
        if (type.typeId() == Type.TypeID.TIMESTAMP) {
            return Timestamps.HOUR;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.TIMESTAMP;
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.IntegerType.get();
    }

    @Override
    public boolean satisfiesOrderOf(Transform<?, ?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Timestamps) {
            return other == Timestamps.HOUR;
        }
        return other instanceof Hours || other instanceof Days || other instanceof Months || other instanceof Years;
    }

    @Override
    public String toHumanString(Type alwaysInt, Integer value) {
        return value != null ? TransformUtil.humanHour(value) : "null";
    }

    public String toString() {
        return "hour";
    }

    Object writeReplace() throws ObjectStreamException {
        return SerializationProxies.HoursTransformProxy.get();
    }
}

