/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.column.assembler.AbstractPrimitiveValueAssembler;
import org.apache.asterix.column.assembler.AssemblerInfo;
import org.apache.asterix.column.assembler.AssemblerState;
import org.apache.asterix.column.assembler.value.IValueGetter;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.column.error.ColumnarValueException;

final class RepeatedPrimitiveValueAssembler
extends AbstractPrimitiveValueAssembler {
    private boolean arrayDelegate = false;
    private int arrayLevel = 0;

    RepeatedPrimitiveValueAssembler(int level, AssemblerInfo info, IColumnValuesReader reader, IValueGetter primitiveValue) {
        super(level, info, reader, primitiveValue);
    }

    @Override
    public void reset(AbstractBytesInputStream in, int numberOfTuples) throws HyracksDataException {
        this.reader.reset(in, numberOfTuples);
    }

    @Override
    public int next(AssemblerState state) throws HyracksDataException {
        if (!state.isInGroup() || this.reader.isRepeatedValue() || this.reader.isDelimiter()) {
            this.next();
        }
        if (this.isDelegate()) {
            this.getParent().end();
        }
        return -1;
    }

    public IColumnValuesReader getReader() {
        return this.reader;
    }

    public void setAsDelegate(int arrayLevel) {
        this.arrayDelegate = true;
        this.arrayLevel = arrayLevel;
    }

    private void next() throws HyracksDataException {
        if (!this.reader.next()) {
            throw this.createException();
        }
        if (this.reader.isNull() && (this.arrayDelegate || this.reader.getLevel() + 1 == this.level)) {
            this.addNullToAncestor(this.reader.getLevel());
        } else if (this.reader.isMissing() && (this.arrayLevel == this.reader.getLevel() || this.reader.getLevel() + 1 == this.level)) {
            this.addMissingToAncestor(this.reader.getLevel());
        } else if (this.reader.isValue()) {
            this.addValueToParent();
        }
    }

    private ColumnarValueException createException() {
        ColumnarValueException e = new ColumnarValueException();
        ObjectNode assemblerNode = e.createNode(this.getClass().getSimpleName());
        assemblerNode.put("isDelegate", this.isDelegate());
        assemblerNode.put("isArrayDelegate", this.arrayDelegate);
        ObjectNode readerNode = assemblerNode.putObject("assemblerReader");
        this.reader.appendReaderInformation(readerNode);
        return e;
    }
}

