/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.reader.value;

import java.io.IOException;
import org.apache.asterix.column.bytes.decoder.ParquetPlainFixedLengthValuesReader;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.values.reader.value.AbstractValueReader;
import org.apache.asterix.dataflow.data.nontagged.comparators.AUUIDPartialBinaryComparatorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public final class UUIDValueReader
extends AbstractValueReader {
    private final ParquetPlainFixedLengthValuesReader uuidReader;
    private IValueReference nextValue;

    public UUIDValueReader() {
        ArrayBackedValueStorage storage = new ArrayBackedValueStorage(16);
        this.uuidReader = new ParquetPlainFixedLengthValuesReader((IPointable)storage);
    }

    @Override
    public void init(AbstractBytesInputStream in, int tupleCount) throws IOException {
        this.uuidReader.initFromPage(in);
    }

    @Override
    public void nextValue() {
        this.nextValue = this.uuidReader.readBytes();
    }

    @Override
    public IValueReference getBytes() {
        return this.nextValue;
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.UUID;
    }

    @Override
    public int compareTo(AbstractValueReader o) {
        return AUUIDPartialBinaryComparatorFactory.compare((IValueReference)this.nextValue, (IValueReference)o.getBytes());
    }
}

