/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import java.util.Objects;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.temporal.DateTimeFormatUtils;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class DayOfWeekEval
implements IScalarEvaluator {
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IPointable arg0Ptr = new VoidPointable();
    private final IPointable arg1Ptr;
    private final UTF8StringPointable str1Ptr;
    private final GregorianCalendarSystem calSystem = GregorianCalendarSystem.getInstance();
    private final ISerializerDeserializer<AInt64> int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private final AMutableInt64 aInt64 = new AMutableInt64(0L);
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final FunctionIdentifier fid;
    private final SourceLocation sourceLoc;

    public DayOfWeekEval(IScalarEvaluator eval0, IScalarEvaluator eval1, FunctionIdentifier fid, SourceLocation sourceLoc) {
        this.eval0 = Objects.requireNonNull(eval0);
        this.eval1 = eval1;
        this.arg1Ptr = eval1 != null ? new VoidPointable() : null;
        this.str1Ptr = eval1 != null ? new UTF8StringPointable() : null;
        this.fid = Objects.requireNonNull(fid);
        this.sourceLoc = sourceLoc;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int dowRaw;
        int dowRawOffset;
        long chronon;
        int offset0;
        this.eval0.evaluate(tuple, this.arg0Ptr);
        if (this.eval1 != null) {
            this.eval1.evaluate(tuple, this.arg1Ptr);
        }
        if (PointableHelper.checkAndSetMissingOrNull(result, this.arg0Ptr, this.arg1Ptr)) {
            return;
        }
        byte[] bytes0 = this.arg0Ptr.getByteArray();
        if (bytes0[offset0 = this.arg0Ptr.getStartOffset()] == ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
            chronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
        } else if (bytes0[offset0] == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
            chronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1)) * 86400000L;
        } else {
            throw new TypeMismatchException(this.sourceLoc, this.fid, 0, bytes0[offset0], ATypeTag.SERIALIZED_DATETIME_TYPE_TAG, ATypeTag.SERIALIZED_DATE_TYPE_TAG);
        }
        int weekStart = 0;
        if (this.eval1 != null) {
            boolean weekStartValid;
            byte[] bytes1 = this.arg1Ptr.getByteArray();
            int offset1 = this.arg1Ptr.getStartOffset();
            ATypeTag tt1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
            switch (tt1) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: 
                case FLOAT: 
                case DOUBLE: {
                    int v = ATypeHierarchy.getIntegerValue((String)this.fid.getName(), (int)1, (byte[])bytes1, (int)offset1);
                    weekStart = v - 1;
                    break;
                }
                case STRING: {
                    int len1 = this.arg1Ptr.getLength();
                    this.str1Ptr.set(bytes1, offset1 + 1, len1 - 1);
                    int str1Len = this.str1Ptr.getStringLength();
                    weekStart = DateTimeFormatUtils.weekdayIDSearch((byte[])this.str1Ptr.getByteArray(), (int)this.str1Ptr.getCharStartOffset(), (int)str1Len, (str1Len == 3 ? 1 : 0) != 0);
                    break;
                }
                default: {
                    throw new TypeMismatchException(this.sourceLoc, this.fid, 1, bytes1[offset1], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                }
            }
            boolean bl = weekStartValid = weekStart >= 0 && weekStart < 7;
            if (!weekStartValid) {
                throw new InvalidDataFormatException(this.sourceLoc, this.fid, "week_start_day");
            }
        }
        int dow0 = (dowRawOffset = (dowRaw = this.calSystem.getDayOfWeek(chronon)) - weekStart) < 0 ? dowRawOffset + 7 : dowRawOffset;
        int dow1 = dow0 + 1;
        this.resultStorage.reset();
        this.aInt64.setValue((long)dow1);
        this.int64Serde.serialize((Object)this.aInt64, this.out);
        result.set((IValueReference)this.resultStorage);
    }
}

