/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.model.ClassItemWrapper;
import org.jibx.binding.model.ClassUtils;
import org.jibx.runtime.JiBXException;
import org.jibx.util.IClass;
import org.jibx.util.IClassItem;
import org.jibx.util.IClassLocator;

public class ClassWrapper
implements IClass {
    private final IClassLocator m_locator;
    private final ClassFile m_class;
    private IClassItem[] m_fields;
    private IClassItem[] m_methods;

    public ClassWrapper(IClassLocator loc, ClassFile clas) {
        this.m_locator = loc;
        this.m_class = clas;
    }

    protected IClassItem buildItem(ClassItem item) {
        return new ClassItemWrapper(this, item);
    }

    @Override
    public String getName() {
        return this.m_class.getName();
    }

    @Override
    public String getSignature() {
        return this.m_class.getSignature();
    }

    @Override
    public String getPackage() {
        return this.m_class.getPackage();
    }

    @Override
    public IClass getSuperClass() {
        ClassFile scf = this.m_class.getSuperFile();
        if (scf == null) {
            return null;
        }
        return new ClassWrapper(this.m_locator, this.m_class.getSuperFile());
    }

    @Override
    public String[] getInterfaces() {
        return this.m_class.getInterfaces();
    }

    @Override
    public String[] getInstanceSigs() {
        try {
            return this.m_class.getInstanceSigs();
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Internal error: instance signatures not found for class " + this.m_class.getName(), e);
        }
    }

    @Override
    public boolean isImplements(String sig) {
        try {
            return this.m_class.isImplements(sig);
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Internal error: instance signatures not found for class " + this.m_class.getName(), e);
        }
    }

    @Override
    public boolean isAbstract() {
        return this.m_class.isAbstract();
    }

    @Override
    public boolean isInterface() {
        return this.m_class.isInterface();
    }

    @Override
    public boolean isModifiable() {
        return this.m_class.isModifiable();
    }

    @Override
    public boolean isSuperclass(String name) {
        for (ClassFile current = this.m_class; current != null; current = current.getSuperFile()) {
            if (!current.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IClassItem getDirectField(String name) {
        ClassItem item = this.m_class.getDirectField(name);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    @Override
    public IClassItem getField(String name) {
        try {
            return this.buildItem(this.m_class.getField(name));
        }
        catch (JiBXException e) {
            return null;
        }
    }

    @Override
    public IClassItem getMethod(String name, String sig) {
        ClassItem item = this.m_class.getMethod(name, sig);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    @Override
    public IClassItem getMethod(String name, String[] sigs) {
        ClassItem item = this.m_class.getMethod(name, sigs);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    @Override
    public IClassItem getInitializerMethod(String sig) {
        ClassItem item = this.m_class.getInitializerMethod(sig);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    @Override
    public IClassItem getStaticMethod(String name, String sig) {
        ClassItem item = this.m_class.getStaticMethod(name, sig);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    @Override
    public boolean isAccessible(IClassItem item) {
        return this.m_class.isAccessible(((ClassItemWrapper)item).getClassItem());
    }

    @Override
    public boolean isAssignable(IClass other) {
        String[] sigs;
        try {
            sigs = this.m_class.getInstanceSigs();
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Internal error: class information not available", e);
        }
        String match = other.getSignature();
        for (int i = 0; i < sigs.length; ++i) {
            if (!match.equals(sigs[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public IClassItem getBestMethod(String name, String type, String[] args) {
        ClassItem item = this.m_class.getBestMethod(name, type, args);
        if (item == null) {
            return null;
        }
        return this.buildItem(item);
    }

    @Override
    public ClassFile getClassFile() {
        return this.m_class;
    }

    @Override
    public Class loadClass() {
        String name = this.m_class.getName();
        Class<?> clas = ClassFile.loadClass(name);
        if (clas == null) {
            try {
                clas = ClassUtils.class.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clas;
    }

    @Override
    public IClassItem[] getFields() {
        if (this.m_fields == null) {
            ClassItem[] items = this.m_class.getFieldItems();
            this.m_fields = new IClassItem[items.length];
            for (int i = 0; i < items.length; ++i) {
                this.m_fields[i] = this.buildItem(items[i]);
            }
        }
        return this.m_fields;
    }

    @Override
    public IClassItem[] getMethods() {
        if (this.m_methods == null) {
            ClassItem[] items = this.m_class.getMethodItems();
            this.m_methods = new IClassItem[items.length];
            for (int i = 0; i < items.length; ++i) {
                this.m_methods[i] = this.buildItem(items[i]);
            }
        }
        return this.m_methods;
    }

    @Override
    public String getJavaDoc() {
        return null;
    }

    @Override
    public IClassLocator getLocator() {
        return this.m_locator;
    }
}

