/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.InheritableTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.ImplementedMethods;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class DocFinder {
    public static Output search(Configuration configuration, Input input) {
        TypeMirror t;
        TypeElement superclass;
        Output output = new Output();
        Utils utils = configuration.utils;
        if (!input.isInheritDocTag) {
            if (input.taglet == null) {
                output.inlineTags = input.isFirstSentence ? utils.getFirstSentenceTrees(input.element) : utils.getBody(input.element);
                output.holder = input.element;
            } else {
                input.taglet.inherit(input, output);
            }
        }
        if (output.inlineTags != null && !output.inlineTags.isEmpty()) {
            return output;
        }
        output.isValidInheritDocTag = false;
        Input inheritedSearchInput = input.copy(configuration.utils);
        inheritedSearchInput.isInheritDocTag = false;
        if (utils.isMethod(input.element)) {
            ExecutableElement overriddenMethod = utils.overriddenMethod((ExecutableElement)input.element);
            if (overriddenMethod != null) {
                inheritedSearchInput.element = overriddenMethod;
                output = DocFinder.search(configuration, inheritedSearchInput);
                output.isValidInheritDocTag = true;
                if (!output.inlineTags.isEmpty()) {
                    return output;
                }
            }
            ImplementedMethods implMethods = new ImplementedMethods((ExecutableElement)input.element, configuration);
            List<ExecutableElement> implementedMethods = implMethods.build();
            for (ExecutableElement implementedMethod : implementedMethods) {
                inheritedSearchInput.element = implementedMethod;
                output = DocFinder.search(configuration, inheritedSearchInput);
                output.isValidInheritDocTag = true;
                if (output.inlineTags.isEmpty()) continue;
                return output;
            }
        } else if (utils.isTypeElement(input.element) && (superclass = utils.asTypeElement(t = ((TypeElement)input.element).getSuperclass())) != null) {
            inheritedSearchInput.element = superclass;
            output = DocFinder.search(configuration, inheritedSearchInput);
            output.isValidInheritDocTag = true;
            if (!output.inlineTags.isEmpty()) {
                return output;
            }
        }
        return output;
    }

    public static class Output {
        public DocTree holderTag;
        public Element holder;
        public List<? extends DocTree> inlineTags = Collections.emptyList();
        public boolean isValidInheritDocTag = true;
        public List<DocTree> tagList = new ArrayList<DocTree>();

        public String toString() {
            String encl = this.holder == null ? "" : this.holder.getEnclosingElement().toString() + "::";
            return "Output{holderTag=" + this.holderTag + ", holder=" + encl + this.holder + ", inlineTags=" + this.inlineTags + ", isValidInheritDocTag=" + this.isValidInheritDocTag + ", tagList=" + this.tagList + '}';
        }
    }

    public static class Input {
        public Element element;
        public InheritableTaglet taglet = null;
        public String tagId = null;
        public final DocTreeInfo docTreeInfo;
        public boolean isFirstSentence = false;
        public boolean isInheritDocTag = false;
        public boolean isTypeVariableParamTag = false;
        public final Utils utils;

        public Input(Utils utils, Element element, InheritableTaglet taglet, DocTreeInfo dtInfo, boolean isFirstSentence, boolean isInheritDocTag) {
            this.utils = utils;
            this.element = element;
            this.taglet = taglet;
            this.isFirstSentence = isFirstSentence;
            this.isInheritDocTag = isInheritDocTag;
            this.docTreeInfo = dtInfo;
        }

        public Input(Utils utils, Element element, InheritableTaglet taglet, String tagId) {
            this(utils, element);
            this.taglet = taglet;
            this.tagId = tagId;
        }

        public Input(Utils utils, Element element, InheritableTaglet taglet, String tagId, boolean isTypeVariableParamTag) {
            this(utils, element);
            this.taglet = taglet;
            this.tagId = tagId;
            this.isTypeVariableParamTag = isTypeVariableParamTag;
        }

        public Input(Utils utils, Element element, InheritableTaglet taglet) {
            this(utils, element);
            this.taglet = taglet;
        }

        public Input(Utils utils, Element element) {
            if (element == null) {
                throw new NullPointerException();
            }
            this.element = element;
            this.utils = utils;
            this.docTreeInfo = new DocTreeInfo();
        }

        public Input(Utils utils, Element element, boolean isFirstSentence) {
            this(utils, element);
            this.isFirstSentence = isFirstSentence;
        }

        public Input copy(Utils utils) {
            if (this.element == null) {
                throw new NullPointerException();
            }
            Input clone = new Input(utils, this.element, this.taglet, this.docTreeInfo, this.isFirstSentence, this.isInheritDocTag);
            clone.tagId = this.tagId;
            clone.isTypeVariableParamTag = this.isTypeVariableParamTag;
            return clone;
        }

        public String toString() {
            String encl = this.element == null ? "" : this.element.getEnclosingElement().toString() + "::";
            return "Input{element=" + encl + this.element + ", taglet=" + this.taglet + ", tagId=" + this.tagId + ", tag=" + this.docTreeInfo + ", isFirstSentence=" + this.isFirstSentence + ", isInheritDocTag=" + this.isInheritDocTag + ", isTypeVariableParamTag=" + this.isTypeVariableParamTag + ", utils=" + this.utils + '}';
        }
    }

    public static final class DocTreeInfo {
        public final DocTree docTree;
        public final Element element;

        public DocTreeInfo() {
            this.docTree = null;
            this.element = null;
        }

        public DocTreeInfo(DocTree docTree, Element baseElement) {
            this.docTree = docTree;
            this.element = baseElement;
        }

        public String toString() {
            return "DocTreeInfo{docTree=" + this.docTree + ", element=" + this.element + '}';
        }
    }
}

