/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import bk-shade.com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;

public class LedgerEntry {
    long ledgerId;
    long entryId;
    long length;
    ByteBuf data;

    LedgerEntry(long lId, long eId) {
        this.ledgerId = lId;
        this.entryId = eId;
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getEntry() {
        Preconditions.checkState(null != this.data, "entry content can be accessed only once");
        byte[] entry = new byte[this.data.readableBytes()];
        this.data.readBytes(entry);
        this.data.release();
        this.data = null;
        return entry;
    }

    public InputStream getEntryInputStream() {
        Preconditions.checkState(null != this.data, "entry content can be accessed only once");
        ByteBufInputStream res = new ByteBufInputStream(this.data);
        this.data = null;
        return res;
    }

    public ByteBuf getEntryBuffer() {
        Preconditions.checkState(null != this.data, "entry content has been retrieved by #getEntry or #getEntryInputStream");
        return this.data;
    }
}

