/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.core.mgmt.persist.ConfigLoader;
import org.apache.brooklyn.util.collections.MutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DeserializingProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DeserializingProvider.class);
    private List<ConfigLoader> loaders;
    private volatile Map<String, String> cache;

    protected DeserializingProvider(List<? extends ConfigLoader> loaders) {
        this.loaders = new ArrayList<ConfigLoader>(loaders);
    }

    public List<ConfigLoader> getLoaders() {
        return this.loaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public Map<String, String> loadDeserializingMapping() {
        DeserializingProvider deserializingProvider = this;
        synchronized (deserializingProvider) {
            if (this.cache == null) {
                MutableMap.Builder builder = MutableMap.builder();
                for (ConfigLoader loader : this.loaders) {
                    builder.putAll(loader.load());
                }
                this.cache = builder.build();
                LOG.debug("Config cache loaded, size {}", (Object)this.cache.size());
            }
            return this.cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DeserializingProvider deserializingProvider = this;
        synchronized (deserializingProvider) {
            this.cache = null;
        }
    }
}

