/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.server;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Time;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynServerPaths {
    private static final Logger log = LoggerFactory.getLogger(BrooklynServerPaths.class);
    public static final String DEFAULT_PERSISTENCE_CONTAINER_NAME = "brooklyn-persisted-state";
    public static final String DEFAULT_PERSISTENCE_DIR_FOR_FILESYSTEM = Os.mergePaths((String[])new String[]{"brooklyn-persisted-state", "data"});

    public static String getMgmtBaseDir(ManagementContext mgmt) {
        return BrooklynServerPaths.getMgmtBaseDir(mgmt.getConfig());
    }

    public static String getMgmtBaseDir(StringConfigMap brooklynProperties) {
        String base = (String)brooklynProperties.getConfigLocalRaw(BrooklynServerConfig.MGMT_BASE_DIR).orNull();
        if (base == null && (base = (String)brooklynProperties.getConfig(BrooklynServerConfig.BROOKLYN_DATA_DIR)) != null) {
            log.warn("Using deprecated " + BrooklynServerConfig.BROOKLYN_DATA_DIR.getName() + ": use " + BrooklynServerConfig.MGMT_BASE_DIR.getName() + " instead; value: " + base);
        }
        if (base == null) {
            base = (String)brooklynProperties.getConfig(BrooklynServerConfig.MGMT_BASE_DIR);
        }
        return Os.tidyPath((String)base) + File.separator;
    }

    public static String getMgmtBaseDir(Map<String, ?> brooklynProperties) {
        String base = (String)brooklynProperties.get(BrooklynServerConfig.MGMT_BASE_DIR.getName());
        if (base == null) {
            base = (String)brooklynProperties.get(BrooklynServerConfig.BROOKLYN_DATA_DIR.getName());
        }
        if (base == null) {
            base = (String)BrooklynServerConfig.MGMT_BASE_DIR.getDefaultValue();
        }
        return Os.tidyPath((String)base) + File.separator;
    }

    protected static String resolveAgainstBaseDir(StringConfigMap brooklynProperties, String path) {
        if (!Os.isAbsolutish((String)path)) {
            path = Os.mergePaths((String[])new String[]{BrooklynServerPaths.getMgmtBaseDir(brooklynProperties), path});
        }
        return Os.tidyPath((String)path);
    }

    public static PersistencePathResolver newMainPersistencePathResolver(StringConfigMap brooklynProperties) {
        return new PersistencePathResolver(brooklynProperties);
    }

    public static PersistencePathResolver newMainPersistencePathResolver(ManagementContext mgmt) {
        return new PersistencePathResolver(mgmt.getConfig());
    }

    public static PersistenceBackupPathResolver newBackupPersistencePathResolver(ManagementContext mgmt) {
        return new PersistenceBackupPathResolver(mgmt.getConfig());
    }

    public static File getBrooklynWebTmpDir(ManagementContext mgmt) {
        String brooklynMgmtBaseDir = BrooklynServerPaths.getMgmtBaseDir(mgmt);
        File webappTempDir = new File(Os.mergePaths((String[])new String[]{brooklynMgmtBaseDir, "planes", mgmt.getManagementNodeId(), "jetty"}));
        try {
            FileUtils.forceMkdir((File)webappTempDir);
            Os.deleteOnExitRecursivelyAndEmptyParentsUpTo((File)webappTempDir, (File)new File(brooklynMgmtBaseDir));
            return webappTempDir;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            IllegalStateException e2 = new IllegalStateException("Cannot create working directory " + webappTempDir + " for embedded jetty server: " + e, e);
            log.warn(e2.getMessage() + " (rethrowing)");
            throw e2;
        }
    }

    public static File getOsgiCacheDir(ManagementContext mgmt) {
        StringConfigMap brooklynProperties = mgmt.getConfig();
        String cacheDir = (String)brooklynProperties.getConfig(BrooklynServerConfig.OSGI_CACHE_DIR);
        cacheDir = TemplateProcessor.processTemplateContents(cacheDir, mgmt, (Map<String, ? extends Object>)MutableMap.of((Object)BrooklynServerConfig.MGMT_BASE_DIR.getName(), (Object)BrooklynServerPaths.getMgmtBaseDir(mgmt), (Object)"brooklyn.mgmt.node.id", (Object)mgmt.getManagementNodeId(), (Object)Os.TmpDirFinder.BROOKLYN_OS_TMPDIR_PROPERTY, (Object)Os.tmp()));
        cacheDir = BrooklynServerPaths.resolveAgainstBaseDir(mgmt.getConfig(), cacheDir);
        return new File(cacheDir);
    }

    public static boolean isOsgiCacheForCleaning(ManagementContext mgmt, File cacheDir) {
        StringConfigMap brooklynProperties = mgmt.getConfig();
        Boolean clean = (Boolean)brooklynProperties.getConfig(BrooklynServerConfig.OSGI_CACHE_CLEAN);
        if (clean == null) {
            clean = cacheDir.getName().contains(mgmt.getManagementNodeId());
        }
        return clean;
    }

    public static File getOsgiCacheDirCleanedIfNeeded(ManagementContext mgmt) {
        File cacheDirF = BrooklynServerPaths.getOsgiCacheDir(mgmt);
        boolean clean = BrooklynServerPaths.isOsgiCacheForCleaning(mgmt, cacheDirF);
        log.debug("OSGi cache dir computed as " + cacheDirF.getAbsolutePath() + " (" + (cacheDirF.exists() ? "already exists" : "does not exist") + ", " + (clean ? "cleaning now (and on exit)" : "cleaning not requested"));
        if (clean) {
            Os.deleteRecursively((File)cacheDirF);
            Os.deleteOnExitRecursively((File)cacheDirF);
        }
        return cacheDirF;
    }

    public static class PersistenceBackupPathResolver
    extends PersistencePathResolver {
        private String nonBackupLocationSpec;

        private PersistenceBackupPathResolver(StringConfigMap brooklynProperties) {
            super(brooklynProperties);
        }

        public PersistenceBackupPathResolver nonBackupLocation(@Nullable String locationSpec) {
            this.nonBackupLocationSpec = locationSpec;
            return this;
        }

        @Override
        public PersistenceBackupPathResolver dir(String dirOrContainer) {
            super.dir(dirOrContainer);
            return this;
        }

        @Override
        public PersistenceBackupPathResolver location(String backupLocationSpec) {
            super.location(backupLocationSpec);
            return this;
        }

        protected boolean isBackupSameLocation() {
            return Objects.equal((Object)this.locationSpec, (Object)this.nonBackupLocationSpec);
        }

        public String resolveWithSubpath(String subpath) {
            return Urls.mergePaths((String[])new String[]{super.resolve(), subpath});
        }

        public String resolveWithSubpathFor(ManagementContext managementContext, String label) {
            return this.resolveWithSubpath(Time.makeDateSimpleStampString() + "-" + managementContext.getManagementNodeId() + "-" + label + "-" + Identifiers.makeRandomId((int)4));
        }

        @Override
        protected String getDefaultPathFromConfig() {
            Maybe result = this.brooklynProperties.getConfigLocalRaw(BrooklynServerConfig.PERSISTENCE_BACKUPS_DIR);
            if (result.isPresent()) {
                return Strings.toString((Object)result.get());
            }
            if (this.isBackupSameLocation()) {
                return this.backupContainerFor((String)this.brooklynProperties.getConfig(BrooklynServerConfig.PERSISTENCE_DIR));
            }
            return null;
        }

        protected String backupContainerFor(String nonBackupContainer) {
            if (nonBackupContainer == null) {
                return null;
            }
            return Urls.mergePaths((String[])new String[]{nonBackupContainer, "backups"});
        }

        @Override
        protected String getDefaultDirForAnyFilesystem() {
            return this.backupContainerFor(BrooklynServerPaths.DEFAULT_PERSISTENCE_CONTAINER_NAME);
        }

        @Override
        protected String getDefaultContainerForAnyNonFilesystem() {
            return this.backupContainerFor(super.getDefaultContainerForAnyNonFilesystem());
        }
    }

    public static class PersistencePathResolver {
        protected final StringConfigMap brooklynProperties;
        protected String locationSpec;
        protected String dirOrContainer;

        private PersistencePathResolver(StringConfigMap brooklynProperties) {
            this.brooklynProperties = brooklynProperties;
        }

        public PersistencePathResolver location(@Nullable String locationSpec) {
            this.locationSpec = locationSpec;
            return this;
        }

        public PersistencePathResolver dir(@Nullable String dirOrContainer) {
            this.dirOrContainer = dirOrContainer;
            return this;
        }

        public String resolve() {
            String path = this.dirOrContainer;
            if (path == null) {
                path = this.getDefaultPathFromConfig();
            }
            if (Strings.isBlank((CharSequence)this.locationSpec) || "localhost".equals(this.locationSpec)) {
                if (Strings.isBlank((CharSequence)path)) {
                    path = this.getDefaultDirForAnyFilesystem();
                }
                return BrooklynServerPaths.resolveAgainstBaseDir(this.brooklynProperties, path);
            }
            if (path == null) {
                path = this.getDefaultContainerForAnyNonFilesystem();
            }
            return path;
        }

        protected String getDefaultPathFromConfig() {
            return (String)this.brooklynProperties.getConfig(BrooklynServerConfig.PERSISTENCE_DIR);
        }

        protected String getDefaultDirForAnyFilesystem() {
            return DEFAULT_PERSISTENCE_DIR_FOR_FILESYSTEM;
        }

        protected String getDefaultContainerForAnyNonFilesystem() {
            return BrooklynServerPaths.DEFAULT_PERSISTENCE_CONTAINER_NAME;
        }
    }
}

