/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.typereg.BrooklynTypePlanTransformer;
import org.apache.brooklyn.core.typereg.RegisteredTypeKindVisitor;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTypePlanTransformer
implements BrooklynTypePlanTransformer {
    private static final Logger log = LoggerFactory.getLogger(AbstractTypePlanTransformer.class);
    protected ManagementContext mgmt;
    private final String format;
    private final String formatName;
    private final String formatDescription;

    @Override
    public void setManagementContext(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    protected AbstractTypePlanTransformer(String format, String formatName, String formatDescription) {
        this.format = format;
        this.formatName = formatName;
        this.formatDescription = formatDescription;
    }

    @Override
    public String getFormatCode() {
        return this.format;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public String getFormatDescription() {
        return this.formatDescription;
    }

    public String toString() {
        return this.getFormatCode() + ":" + JavaClassNames.simpleClassName((Object)this);
    }

    @Override
    public double scoreForType(RegisteredType type, RegisteredTypeLoadingContext context) {
        if (this.getFormatCode().equals(type.getPlan().getPlanFormat())) {
            return 1.0;
        }
        if (type.getPlan().getPlanFormat() == null) {
            return this.scoreForNullFormat(type.getPlan().getPlanData(), type, context);
        }
        return this.scoreForNonmatchingNonnullFormat(type.getPlan().getPlanFormat(), type.getPlan().getPlanData(), type, context);
    }

    protected abstract double scoreForNullFormat(Object var1, RegisteredType var2, RegisteredTypeLoadingContext var3);

    protected abstract double scoreForNonmatchingNonnullFormat(String var1, Object var2, RegisteredType var3, RegisteredTypeLoadingContext var4);

    @Override
    public Object create(final RegisteredType type, final RegisteredTypeLoadingContext context) {
        try {
            return this.tryValidate(new RegisteredTypeKindVisitor<Object>(){

                @Override
                protected Object visitSpec() {
                    try {
                        AbstractBrooklynObjectSpec<?, ?> result = AbstractTypePlanTransformer.this.createSpec(type, context);
                        result.stackCatalogItemId(type.getId());
                        return result;
                    }
                    catch (Exception e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }

                @Override
                protected Object visitBean() {
                    try {
                        return AbstractTypePlanTransformer.this.createBean(type, context);
                    }
                    catch (Exception e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }

                @Override
                protected Object visitUnresolved() {
                    try {
                        log.debug("Request for " + this + " to validate UNRESOLVED kind " + type + "; trying as spec");
                        Object result = this.visitSpec();
                        log.warn("Request to use " + this + " from UNRESOLVED state succeeded treating is as a spec");
                        log.debug("Trace for request to use " + this + " in UNRESOLVED state succeeding", new Throwable("Location of request to use " + this + " in UNRESOLVED state"));
                        return result;
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        throw new IllegalStateException(type + " is in registry but its definition cannot be resolved", e);
                    }
                }
            }.visit(type.getKind()), type, context).get();
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            if (!(e instanceof UnsupportedTypePlanException)) {
                log.debug("Could not instantiate " + type + " (rethrowing): " + Exceptions.collapseText((Throwable)e));
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected <T> Maybe<T> tryValidate(T createdObject, RegisteredType type, RegisteredTypeLoadingContext constraint) {
        return RegisteredTypes.tryValidate(createdObject, type, constraint);
    }

    protected abstract AbstractBrooklynObjectSpec<?, ?> createSpec(RegisteredType var1, RegisteredTypeLoadingContext var2) throws Exception;

    protected abstract Object createBean(RegisteredType var1, RegisteredTypeLoadingContext var2) throws Exception;
}

