/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid;

import java.util.Set;
import org.jclouds.gogrid.domain.internal.ErrorResponse;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.javax.annotation.Nullable;

public class GoGridResponseException
extends HttpResponseException {
    private transient Set<ErrorResponse> errors;

    public GoGridResponseException(HttpCommand command, HttpResponse response, Set<ErrorResponse> errors) {
        super(GoGridResponseException.buildMessage(command, response, errors), command, response);
        this.setErrors(errors);
    }

    @Nullable
    public Set<ErrorResponse> getError() {
        return this.errors;
    }

    public void setErrors(Set<ErrorResponse> errors) {
        this.errors = errors;
    }

    private static String buildMessage(HttpCommand command, HttpResponse response, Set<ErrorResponse> errors) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("command %s failed with code %s. ", command.toString(), response.getStatusCode()));
        for (ErrorResponse error : errors) {
            builder.append(String.format("Error [%s]: %s. ", error.getErrorCode(), error.getMessage()));
        }
        return builder.toString();
    }
}

