/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

public enum NetworkType {
    LOCAL("local"),
    FLAT("flat"),
    VLAN("vlan"),
    VXLAN("vxlan"),
    GRE("gre"),
    UNRECOGNIZED("unrecognized");

    private String name;

    private NetworkType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static NetworkType fromValue(String name) {
        if (name != null) {
            for (NetworkType value : NetworkType.values()) {
                if (!name.equalsIgnoreCase(value.name)) continue;
                return value;
            }
            return UNRECOGNIZED;
        }
        return null;
    }
}

