/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.mariadb;

import com.google.common.base.Function;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.entity.database.mariadb.MariaDbDriver;
import org.apache.brooklyn.entity.database.mariadb.MariaDbNode;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbNodeImpl
extends SoftwareProcessImpl
implements MariaDbNode {
    private static final Logger LOG = LoggerFactory.getLogger(MariaDbNodeImpl.class);
    private SshFeed feed;

    public Class<?> getDriverInterface() {
        return MariaDbDriver.class;
    }

    public MariaDbDriver getDriver() {
        return (MariaDbDriver)super.getDriver();
    }

    public void init() {
        super.init();
        this.getMutableEntityType().addEffector(EXECUTE_SCRIPT, (EffectorBody)new EffectorBody<String>(){

            public String call(ConfigBag parameters) {
                return MariaDbNodeImpl.this.executeScript((String)parameters.getStringKey("commands"));
            }
        });
    }

    protected void connectSensors() {
        super.connectSensors();
        this.sensors().set(DATASTORE_URL, (Object)String.format("mysql://%s:%s/", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)MARIADB_PORT)));
        Maybe machine = Locations.findUniqueSshMachineLocation((Iterable)this.getLocations());
        if (machine.isPresent()) {
            String cmd = this.getDriver().getStatusCmd();
            this.feed = (SshFeed)((SshFeed.Builder)((SshFeed.Builder)((SshFeed.Builder)SshFeed.builder().entity((Entity)this)).period((Duration)this.config().get(SERVICE_PROCESS_IS_RUNNING_POLL_PERIOD))).machine((MachineLocation)machine.get())).poll((CommandPollConfig)((CommandPollConfig)new SshPollConfig(SERVICE_UP).command(cmd).setOnSuccess((Object)true)).setOnFailureOrException((Object)false)).poll((CommandPollConfig)((CommandPollConfig)new SshPollConfig(QUERIES_PER_SECOND_FROM_MARIADB).command(cmd).onSuccess((Function)new Function<SshPollValue, Double>(){

                public Double apply(SshPollValue input) {
                    String q = Strings.getFirstWordAfter((String)input.getStdout(), (String)"Queries per second avg:");
                    return q == null ? null : Double.valueOf(Double.parseDouble(q));
                }
            })).setOnFailureOrException(null)).build();
        } else {
            LOG.warn("Location(s) {} not an ssh-machine location, so not polling for status; setting serviceUp immediately", (Object)this.getLocations());
            this.sensors().set(SERVICE_UP, (Object)true);
        }
    }

    protected void disconnectSensors() {
        if (this.feed != null) {
            this.feed.stop();
        }
        super.disconnectSensors();
    }

    public int getPort() {
        return (Integer)this.getAttribute((AttributeSensor)MARIADB_PORT);
    }

    public String getSocketUid() {
        String result = (String)this.getAttribute((AttributeSensor)MariaDbNode.SOCKET_UID);
        if (Strings.isBlank((CharSequence)result)) {
            result = Identifiers.makeRandomId((int)6);
            this.sensors().set((AttributeSensor)MariaDbNode.SOCKET_UID, (Object)result);
        }
        return result;
    }

    public String getPassword() {
        String result = (String)this.getAttribute((AttributeSensor)MariaDbNode.PASSWORD);
        if (Strings.isBlank((CharSequence)result)) {
            result = Identifiers.makeRandomId((int)6);
            this.sensors().set((AttributeSensor)MariaDbNode.PASSWORD, (Object)result);
        }
        return result;
    }

    public String getShortName() {
        return "MariaDB";
    }

    @Override
    public String executeScript(String commands) {
        return this.getDriver().executeScriptAsync(commands).block().getStdout();
    }
}

