/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.StartableMethods;
import org.apache.brooklyn.test.framework.ParallelTestCase;
import org.apache.brooklyn.test.framework.TargetableTestComponentImpl;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelTestCaseImpl
extends TargetableTestComponentImpl
implements ParallelTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ParallelTestCaseImpl.class);

    public void start(Collection<? extends Location> locations) {
        this.sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.STARTING);
        try {
            TaskAdaptable taskAdaptable = StartableMethods.startingChildren((Entity)this, locations);
            logger.trace("{}, TaskAdaptable: {}", (Object)this, (Object)taskAdaptable);
            this.submitTaskAndWait(taskAdaptable);
            logger.debug("Tasks successfully run. Update state of {} to RUNNING.", (Object)this);
            this.setServiceState(true, Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            logger.debug("Tasks NOT successfully run. Update state of {} to ON_FIRE.", (Object)this);
            this.setServiceState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    public void stop() {
        this.sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.STOPPING);
        TaskAdaptable taskAdaptable = StartableMethods.stoppingChildren((Entity)this);
        logger.trace("{}, TaskAdaptable: {}", (Object)this, (Object)taskAdaptable);
        try {
            this.submitTaskAndWait(taskAdaptable);
            logger.debug("Tasks successfully run. Update state of {} to STOPPED.", (Object)this);
            this.setServiceState(false, Lifecycle.STOPPED);
        }
        catch (Throwable t) {
            logger.debug("Tasks NOT successfully run. Update state of {} to ON_FIRE.", (Object)this);
            this.setServiceState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    public void restart() {
        this.setServiceState(false, Lifecycle.STARTING);
        TaskAdaptable taskAdaptable = StartableMethods.restartingChildren((Entity)this);
        logger.trace("{}, TaskAdaptable: {}", (Object)this, (Object)taskAdaptable);
        try {
            this.submitTaskAndWait(taskAdaptable);
            logger.debug("Tasks successfully run. Update state of {} to RUNNING.", (Object)this);
            this.setServiceState(true, Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            logger.debug("Tasks NOT successfully run. Update state of {} to ON_FIRE.", (Object)this);
            this.setServiceState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    private void submitTaskAndWait(TaskAdaptable<?> taskAdaptable) {
        DynamicTasks.queue(taskAdaptable);
        DynamicTasks.waitForLast();
    }

    private void setServiceState(boolean serviceUpState, Lifecycle serviceStateActual) {
        this.sensors().set(Attributes.SERVICE_UP, (Object)serviceUpState);
        this.sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)serviceStateActual);
    }
}

