/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.huc;

import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.InternalCache;
import com.squareup.okhttp.internal.http.CacheRequest;
import com.squareup.okhttp.internal.http.CacheStrategy;
import com.squareup.okhttp.internal.huc.JavaApiConverter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URI;
import java.util.List;
import java.util.Map;
import okio.Okio;
import okio.Sink;

public final class CacheAdapter
implements InternalCache {
    private final ResponseCache delegate;

    public CacheAdapter(ResponseCache delegate) {
        this.delegate = delegate;
    }

    public ResponseCache getDelegate() {
        return this.delegate;
    }

    @Override
    public Response get(Request request) throws IOException {
        CacheResponse javaResponse = this.getJavaCachedResponse(request);
        if (javaResponse == null) {
            return null;
        }
        return JavaApiConverter.createOkResponse(request, javaResponse);
    }

    @Override
    public CacheRequest put(Response response) throws IOException {
        HttpURLConnection connection;
        URI uri = response.request().uri();
        final java.net.CacheRequest request = this.delegate.put(uri, connection = JavaApiConverter.createJavaUrlConnection(response));
        if (request == null) {
            return null;
        }
        return new CacheRequest(){

            @Override
            public Sink body() throws IOException {
                OutputStream body = request.getBody();
                return body != null ? Okio.sink((OutputStream)body) : null;
            }

            @Override
            public void abort() {
                request.abort();
            }
        };
    }

    @Override
    public void remove(Request request) throws IOException {
    }

    @Override
    public void update(Response cached, Response network) throws IOException {
    }

    @Override
    public void trackConditionalCacheHit() {
    }

    @Override
    public void trackResponse(CacheStrategy cacheStrategy) {
    }

    private CacheResponse getJavaCachedResponse(Request request) throws IOException {
        Map<String, List<String>> headers = JavaApiConverter.extractJavaHeaders(request);
        return this.delegate.get(request.uri(), request.method(), headers);
    }
}

