/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ConfigFluent;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluentImpl;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedClusterBuilder;
import io.fabric8.kubernetes.api.model.NamedClusterFluentImpl;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.NamedContextFluentImpl;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.Preferences;
import io.fabric8.kubernetes.api.model.PreferencesBuilder;
import io.fabric8.kubernetes.api.model.PreferencesFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigFluentImpl<A extends ConfigFluent<A>>
extends BaseFluent<A>
implements ConfigFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends NamedCluster, ?>> clusters = new ArrayList();
    private List<VisitableBuilder<? extends NamedContext, ?>> contexts = new ArrayList();
    private String currentContext;
    private List<VisitableBuilder<? extends NamedExtension, ?>> extensions = new ArrayList();
    private String kind;
    private VisitableBuilder<? extends Preferences, ?> preferences;
    private List<VisitableBuilder<? extends NamedAuthInfo, ?>> users = new ArrayList();

    public ConfigFluentImpl() {
    }

    public ConfigFluentImpl(Config instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withClusters(instance.getClusters());
        this.withContexts(instance.getContexts());
        this.withCurrentContext(instance.getCurrentContext());
        this.withExtensions(instance.getExtensions());
        this.withKind(instance.getKind());
        this.withPreferences(instance.getPreferences());
        this.withUsers(instance.getUsers());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToClusters(NamedCluster ... items) {
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.add(builder);
            this.clusters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusters(NamedCluster ... items) {
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.remove(builder);
            this.clusters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedCluster> getClusters() {
        return ConfigFluentImpl.build(this.clusters);
    }

    @Override
    public A withClusters(List<NamedCluster> clusters) {
        this._visitables.removeAll(this.clusters);
        this.clusters.clear();
        if (clusters != null) {
            for (NamedCluster item : clusters) {
                this.addToClusters(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withClusters(NamedCluster ... clusters) {
        this.clusters.clear();
        if (clusters != null) {
            for (NamedCluster item : clusters) {
                this.addToClusters(item);
            }
        }
        return (A)this;
    }

    @Override
    public ConfigFluent.ClustersNested<A> addNewCluster() {
        return new ClustersNestedImpl();
    }

    @Override
    public ConfigFluent.ClustersNested<A> addNewClusterLike(NamedCluster item) {
        return new ClustersNestedImpl(item);
    }

    @Override
    public A addToContexts(NamedContext ... items) {
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.add(builder);
            this.contexts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContexts(NamedContext ... items) {
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.remove(builder);
            this.contexts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedContext> getContexts() {
        return ConfigFluentImpl.build(this.contexts);
    }

    @Override
    public A withContexts(List<NamedContext> contexts) {
        this._visitables.removeAll(this.contexts);
        this.contexts.clear();
        if (contexts != null) {
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withContexts(NamedContext ... contexts) {
        this.contexts.clear();
        if (contexts != null) {
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        }
        return (A)this;
    }

    @Override
    public ConfigFluent.ContextsNested<A> addNewContext() {
        return new ContextsNestedImpl();
    }

    @Override
    public ConfigFluent.ContextsNested<A> addNewContextLike(NamedContext item) {
        return new ContextsNestedImpl(item);
    }

    @Override
    public String getCurrentContext() {
        return this.currentContext;
    }

    @Override
    public A withCurrentContext(String currentContext) {
        this.currentContext = currentContext;
        return (A)this;
    }

    @Override
    public A addToExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedExtension> getExtensions() {
        return ConfigFluentImpl.build(this.extensions);
    }

    @Override
    public A withExtensions(List<NamedExtension> extensions) {
        this._visitables.removeAll(this.extensions);
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public ConfigFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public ConfigFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Preferences getPreferences() {
        return this.preferences != null ? (Preferences)this.preferences.build() : null;
    }

    @Override
    public A withPreferences(Preferences preferences) {
        this._visitables.remove(this.preferences);
        if (preferences != null) {
            this.preferences = new PreferencesBuilder(preferences);
            this._visitables.add(this.preferences);
        }
        return (A)this;
    }

    @Override
    public ConfigFluent.PreferencesNested<A> withNewPreferences() {
        return new PreferencesNestedImpl();
    }

    @Override
    public ConfigFluent.PreferencesNested<A> withNewPreferencesLike(Preferences item) {
        return new PreferencesNestedImpl(item);
    }

    @Override
    public ConfigFluent.PreferencesNested<A> editPreferences() {
        return this.withNewPreferencesLike(this.getPreferences());
    }

    @Override
    public ConfigFluent.PreferencesNested<A> editOrNewPreferences() {
        return this.withNewPreferencesLike(this.getPreferences() != null ? this.getPreferences() : new PreferencesBuilder().build());
    }

    @Override
    public ConfigFluent.PreferencesNested<A> editOrNewPreferencesLike(Preferences item) {
        return this.withNewPreferencesLike(this.getPreferences() != null ? this.getPreferences() : item);
    }

    @Override
    public A addToUsers(NamedAuthInfo ... items) {
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.add(builder);
            this.users.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsers(NamedAuthInfo ... items) {
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.remove(builder);
            this.users.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedAuthInfo> getUsers() {
        return ConfigFluentImpl.build(this.users);
    }

    @Override
    public A withUsers(List<NamedAuthInfo> users) {
        this._visitables.removeAll(this.users);
        this.users.clear();
        if (users != null) {
            for (NamedAuthInfo item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withUsers(NamedAuthInfo ... users) {
        this.users.clear();
        if (users != null) {
            for (NamedAuthInfo item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public ConfigFluent.UsersNested<A> addNewUser() {
        return new UsersNestedImpl();
    }

    @Override
    public ConfigFluent.UsersNested<A> addNewUserLike(NamedAuthInfo item) {
        return new UsersNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigFluentImpl that = (ConfigFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.clusters != null ? !this.clusters.equals(that.clusters) : that.clusters != null) {
            return false;
        }
        if (this.contexts != null ? !this.contexts.equals(that.contexts) : that.contexts != null) {
            return false;
        }
        if (this.currentContext != null ? !this.currentContext.equals(that.currentContext) : that.currentContext != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.preferences != null ? !this.preferences.equals(that.preferences) : that.preferences != null) {
            return false;
        }
        return !(this.users != null ? !this.users.equals(that.users) : that.users != null);
    }

    public class UsersNestedImpl<N>
    extends NamedAuthInfoFluentImpl<ConfigFluent.UsersNested<N>>
    implements ConfigFluent.UsersNested<N>,
    Nested<N> {
        private final NamedAuthInfoBuilder builder;

        UsersNestedImpl(NamedAuthInfo item) {
            this.builder = new NamedAuthInfoBuilder(this, item);
        }

        UsersNestedImpl() {
            this.builder = new NamedAuthInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.addToUsers(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }

    public class PreferencesNestedImpl<N>
    extends PreferencesFluentImpl<ConfigFluent.PreferencesNested<N>>
    implements ConfigFluent.PreferencesNested<N>,
    Nested<N> {
        private final PreferencesBuilder builder;

        PreferencesNestedImpl(Preferences item) {
            this.builder = new PreferencesBuilder(this, item);
        }

        PreferencesNestedImpl() {
            this.builder = new PreferencesBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.withPreferences(this.builder.build());
        }

        @Override
        public N endPreferences() {
            return this.and();
        }
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<ConfigFluent.ExtensionsNested<N>>
    implements ConfigFluent.ExtensionsNested<N>,
    Nested<N> {
        private final NamedExtensionBuilder builder;

        ExtensionsNestedImpl(NamedExtension item) {
            this.builder = new NamedExtensionBuilder(this, item);
        }

        ExtensionsNestedImpl() {
            this.builder = new NamedExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.addToExtensions(this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }

    public class ContextsNestedImpl<N>
    extends NamedContextFluentImpl<ConfigFluent.ContextsNested<N>>
    implements ConfigFluent.ContextsNested<N>,
    Nested<N> {
        private final NamedContextBuilder builder;

        ContextsNestedImpl(NamedContext item) {
            this.builder = new NamedContextBuilder(this, item);
        }

        ContextsNestedImpl() {
            this.builder = new NamedContextBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.addToContexts(this.builder.build());
        }

        @Override
        public N endContext() {
            return this.and();
        }
    }

    public class ClustersNestedImpl<N>
    extends NamedClusterFluentImpl<ConfigFluent.ClustersNested<N>>
    implements ConfigFluent.ClustersNested<N>,
    Nested<N> {
        private final NamedClusterBuilder builder;

        ClustersNestedImpl(NamedCluster item) {
            this.builder = new NamedClusterBuilder(this, item);
        }

        ClustersNestedImpl() {
            this.builder = new NamedClusterBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.addToClusters(this.builder.build());
        }

        @Override
        public N endCluster() {
            return this.and();
        }
    }
}

