/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class EndpointsFluentImpl<A extends EndpointsFluent<A>>
extends BaseFluent<A>
implements EndpointsFluent<A> {
    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private List<VisitableBuilder<? extends EndpointSubset, ?>> subsets = new ArrayList();

    public EndpointsFluentImpl() {
    }

    public EndpointsFluentImpl(Endpoints instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSubsets(instance.getSubsets());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public EndpointsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EndpointsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EndpointsFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public EndpointsFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public EndpointsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToSubsets(EndpointSubset ... items) {
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubsets(EndpointSubset ... items) {
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.remove(builder);
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<EndpointSubset> getSubsets() {
        return EndpointsFluentImpl.build(this.subsets);
    }

    @Override
    public A withSubsets(List<EndpointSubset> subsets) {
        this._visitables.removeAll(this.subsets);
        this.subsets.clear();
        if (subsets != null) {
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSubsets(EndpointSubset ... subsets) {
        this.subsets.clear();
        if (subsets != null) {
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (A)this;
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> addNewSubset() {
        return new SubsetsNestedImpl();
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> addNewSubsetLike(EndpointSubset item) {
        return new SubsetsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointsFluentImpl that = (EndpointsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.subsets != null ? !this.subsets.equals(that.subsets) : that.subsets != null);
    }

    public class SubsetsNestedImpl<N>
    extends EndpointSubsetFluentImpl<EndpointsFluent.SubsetsNested<N>>
    implements EndpointsFluent.SubsetsNested<N>,
    Nested<N> {
        private final EndpointSubsetBuilder builder;

        SubsetsNestedImpl(EndpointSubset item) {
            this.builder = new EndpointSubsetBuilder(this, item);
        }

        SubsetsNestedImpl() {
            this.builder = new EndpointSubsetBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointsFluentImpl.this.addToSubsets(this.builder.build());
        }

        @Override
        public N endSubset() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<EndpointsFluent.MetadataNested<N>>
    implements EndpointsFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

