/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecFluentImpl;

public class HorizontalPodAutoscalerSpecBuilder
extends HorizontalPodAutoscalerSpecFluentImpl<HorizontalPodAutoscalerSpecBuilder>
implements VisitableBuilder<HorizontalPodAutoscalerSpec, HorizontalPodAutoscalerSpecBuilder> {
    HorizontalPodAutoscalerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerSpecBuilder() {
        this(true);
    }

    public HorizontalPodAutoscalerSpecBuilder(Boolean validationEnabled) {
        this(new HorizontalPodAutoscalerSpec(), validationEnabled);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscalerSpec(), validationEnabled);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent, HorizontalPodAutoscalerSpec instance) {
        this(fluent, instance, true);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent, HorizontalPodAutoscalerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCpuUtilization(instance.getCpuUtilization());
        fluent.withMaxReplicas(instance.getMaxReplicas());
        fluent.withMinReplicas(instance.getMinReplicas());
        fluent.withScaleRef(instance.getScaleRef());
        this.validationEnabled = validationEnabled;
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance) {
        this(instance, (Boolean)true);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCpuUtilization(instance.getCpuUtilization());
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleRef(instance.getScaleRef());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HorizontalPodAutoscalerSpec build() {
        HorizontalPodAutoscalerSpec buildable = new HorizontalPodAutoscalerSpec(this.fluent.getCpuUtilization(), this.fluent.getMaxReplicas(), this.fluent.getMinReplicas(), this.fluent.getScaleRef());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerSpecBuilder that = (HorizontalPodAutoscalerSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

