/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.CaseFormat;

public enum Hypervisor {
    XEN,
    OVM,
    UNRECOGNIZED;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static Hypervisor fromValue(String v) {
        try {
            return Hypervisor.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, v));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

