/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.action.osgi;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public abstract class SingleServiceTracker<T> {
    private final BundleContext ctx;
    private final Class<T> clazz;
    private final AtomicReference<T> service = new AtomicReference();
    private final AtomicReference<ServiceReference<T>> ref = new AtomicReference();
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final ServiceListener listener = event -> {
        if (this.open.get()) {
            if (event.getType() == 4) {
                ServiceReference deadRef = event.getServiceReference();
                if (deadRef.equals(this.ref.get())) {
                    this.findMatchingReference(deadRef);
                }
            } else if (event.getType() == 1 && this.ref.get() == null) {
                this.findMatchingReference(null);
            }
        }
    };

    public SingleServiceTracker(BundleContext context, Class<T> clazz) {
        this.ctx = context;
        this.clazz = clazz;
    }

    protected abstract void updateState(T var1, T var2);

    public void open() {
        if (this.open.compareAndSet(false, true)) {
            try {
                String filterString = "(objectClass=" + this.clazz.getName() + ')';
                this.ctx.addServiceListener(this.listener, filterString);
                this.findMatchingReference(null);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            this.ctx.removeServiceListener(this.listener);
            SingleServiceTracker singleServiceTracker = this;
            synchronized (singleServiceTracker) {
                ServiceReference deadRef = this.ref.getAndSet(null);
                this.service.set(null);
                if (deadRef != null) {
                    this.ctx.ungetService(deadRef);
                }
            }
        }
    }

    private void findMatchingReference(ServiceReference<T> original) {
        boolean clear = true;
        ServiceReference ref = this.ctx.getServiceReference(this.clazz);
        if (ref != null) {
            Object service = this.ctx.getService(ref);
            if (service != null) {
                clear = false;
                if (!this.update(original, ref, service)) {
                    this.ctx.ungetService(ref);
                }
            }
        } else if (original == null) {
            clear = false;
        }
        if (clear) {
            this.update(original, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(ServiceReference<T> deadRef, ServiceReference<T> newRef, T service) {
        boolean result = false;
        Object lock = newRef != null ? newRef : (deadRef != null ? deadRef : this);
        T old = null;
        Object object = lock;
        synchronized (object) {
            if (this.open.get() && (result = this.ref.compareAndSet(deadRef, newRef))) {
                old = this.service.getAndSet(service);
            }
        }
        this.updateState(old, service);
        return result;
    }

    public Class<?> getTrackedClass() {
        return this.clazz;
    }
}

