/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.providers.ProviderMetadata;

public abstract class BaseProviderMetadata
implements ProviderMetadata {
    protected final String id;
    protected final String name;
    protected final ApiMetadata api;
    protected final String endpoint;
    protected final Properties defaultProperties;
    protected final Optional<URI> homepage;
    protected final Optional<URI> console;
    protected final Set<String> linkedServices;
    protected final Set<String> iso3166Codes;

    @Override
    public ProviderMetadata.Builder toBuilder() {
        return new Builder().fromProviderMetadata(this);
    }

    public BaseProviderMetadata(Builder builder) {
        this(builder.id, builder.name, builder.api, builder.endpoint, builder.defaultProperties, (Optional<URI>)Optional.fromNullable((Object)builder.homepage), (Optional<URI>)Optional.fromNullable((Object)builder.console), builder.linkedServices, builder.iso3166Codes);
    }

    public BaseProviderMetadata(String id, String name, ApiMetadata api, String endpoint, Properties defaultProperties, Optional<URI> homepage, Optional<URI> console, Set<String> linkedServices, Set<String> iso3166Codes) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.api = (ApiMetadata)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint");
        this.console = (Optional)Preconditions.checkNotNull(console, (Object)"console");
        this.defaultProperties = (Properties)Preconditions.checkNotNull((Object)defaultProperties, (Object)"defaultProperties");
        this.homepage = (Optional)Preconditions.checkNotNull(homepage, (Object)"homepage");
        this.linkedServices = ImmutableSet.copyOf(linkedServices);
        this.iso3166Codes = ImmutableSet.copyOf(iso3166Codes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ProviderMetadata)) {
            return false;
        }
        ProviderMetadata that = (ProviderMetadata)ProviderMetadata.class.cast(o);
        return Objects.equal((Object)this.getId(), (Object)that.getId()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getApiMetadata(), (Object)that.getApiMetadata()) && Objects.equal((Object)this.getEndpoint(), (Object)that.getEndpoint());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getName(), this.getApiMetadata(), this.getEndpoint()});
    }

    public String toString() {
        return this.string().toString();
    }

    public MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("api", (Object)this.getApiMetadata()).add("endpoint", (Object)this.getEndpoint()).add("console", this.getConsole()).add("homepage", this.getHomepage()).add("linkedServices", this.getLinkedServices()).add("iso3166Codes", this.getIso3166Codes());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ApiMetadata getApiMetadata() {
        return this.api;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Optional<URI> getConsole() {
        return this.console;
    }

    @Override
    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public Optional<URI> getHomepage() {
        return this.homepage;
    }

    @Override
    public Set<String> getLinkedServices() {
        return this.linkedServices;
    }

    @Override
    public Set<String> getIso3166Codes() {
        return this.iso3166Codes;
    }

    public static class Builder
    implements ProviderMetadata.Builder {
        protected String id;
        protected String name;
        protected ApiMetadata api;
        protected String endpoint;
        protected Properties defaultProperties = new Properties();
        protected URI console;
        protected URI homepage;
        protected Set<String> linkedServices = Sets.newLinkedHashSet();
        protected Set<String> iso3166Codes = Sets.newLinkedHashSet();

        @Override
        public Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this.linkedService(id);
        }

        @Override
        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        @Override
        public Builder apiMetadata(ApiMetadata api) {
            this.api = (ApiMetadata)Preconditions.checkNotNull((Object)api, (Object)"api");
            if (this.endpoint == null) {
                this.endpoint = (String)api.getDefaultEndpoint().orNull();
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint");
            return this;
        }

        @Override
        public Builder defaultProperties(Properties defaultProperties) {
            this.defaultProperties = (Properties)Preconditions.checkNotNull((Object)defaultProperties, (Object)"defaultProperties");
            return this;
        }

        @Override
        public Builder console(@Nullable URI console) {
            this.console = console;
            return this;
        }

        @Override
        public Builder homepage(URI homepage) {
            this.homepage = homepage;
            return this;
        }

        @Override
        public Builder linkedServices(Iterable<String> linkedServices) {
            Iterables.addAll(this.linkedServices, (Iterable)((Iterable)Preconditions.checkNotNull(linkedServices, (Object)"linkedServices")));
            return this;
        }

        @Override
        public Builder linkedServices(String ... linkedServices) {
            return this.linkedServices((Iterable)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)linkedServices, (Object)"linkedServices"))));
        }

        @Override
        public Builder linkedService(String linkedService) {
            this.linkedServices.add((String)Preconditions.checkNotNull((Object)linkedService, (Object)"linkedService"));
            return this;
        }

        @Override
        public Builder iso3166Codes(Iterable<String> iso3166Codes) {
            Iterables.addAll(this.iso3166Codes, (Iterable)((Iterable)Preconditions.checkNotNull(iso3166Codes, (Object)"iso3166Codes")));
            return this;
        }

        @Override
        public Builder iso3166Codes(String ... iso3166Codes) {
            return this.iso3166Codes((Iterable)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)iso3166Codes, (Object)"iso3166Codes"))));
        }

        @Override
        public Builder iso3166Code(String iso3166Code) {
            this.iso3166Codes.add((String)Preconditions.checkNotNull((Object)iso3166Code, (Object)"iso3166Code"));
            return this;
        }

        @Override
        public Builder fromProviderMetadata(ProviderMetadata in) {
            return ((Builder)this.id(in.getId()).name(in.getName()).apiMetadata(in.getApiMetadata()).endpoint(in.getEndpoint()).defaultProperties(in.getDefaultProperties()).console((URI)in.getConsole().orNull()).homepage((URI)in.getHomepage().orNull()).linkedServices(in.getLinkedServices())).iso3166Codes(in.getIso3166Codes());
        }

        @Override
        public ProviderMetadata build() {
            return new BaseProviderMetadata(this){};
        }
    }
}

