/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.binders;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import org.jclouds.googlecloudstorage.domain.templates.ObjectTemplate;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.MultipartForm;
import org.jclouds.io.payloads.Part;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.json.Json;
import org.jclouds.rest.MapBinder;

public final class MultipartUploadBinder
implements MapBinder {
    private static final String BOUNDARY_HEADER = "multipart_boundary";
    private final Json json;

    @Inject
    MultipartUploadBinder(Json json) {
        this.json = json;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ObjectTemplate template = (ObjectTemplate)postParams.get("template");
        Payload payload = (Payload)postParams.get("payload");
        String contentType = (String)Preconditions.checkNotNull((Object)template.contentType(), (Object)"contentType");
        Long length = (Long)Preconditions.checkNotNull((Object)template.size(), (Object)"contentLength");
        StringPayload jsonPayload = Payloads.newStringPayload((String)this.json.toJson((Object)template));
        payload.getContentMetadata().setContentLength(length);
        Part jsonPart = Part.create((String)"Metadata", (Payload)jsonPayload, (Part.PartOptions)new Part.PartOptions().contentType("application/json"));
        Part mediaPart = Part.create((String)template.name(), (Payload)payload, (Part.PartOptions)new Part.PartOptions().contentType(contentType));
        request.setPayload((Payload)new MultipartForm(BOUNDARY_HEADER, new Part[]{jsonPart, mediaPart}));
        ((HttpRequest.Builder)request.toBuilder().replaceHeader("Content-Type", new String[]{"Multipart/related; boundary= multipart_boundary"})).build();
        return request;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return request;
    }
}

