/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.activemq6.ActiveMQComponent;

/**
 * Send messages to (or consume from) Apache ActiveMQ 6.x. This component
 * extends the Camel JMS component.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface Activemq6ComponentBuilderFactory {

    /**
     * ActiveMQ 6.x (camel-activemq6)
     * Send messages to (or consume from) Apache ActiveMQ 6.x. This component
     * extends the Camel JMS component.
     * 
     * Category: messaging
     * Since: 4.7
     * Maven coordinates: org.apache.camel:camel-activemq6
     * 
     * @return the dsl builder
     */
    static Activemq6ComponentBuilder activemq6() {
        return new Activemq6ComponentBuilderImpl();
    }

    /**
     * Builder for the ActiveMQ 6.x component.
     */
    interface Activemq6ComponentBuilder extends ComponentBuilder<ActiveMQComponent> {
    
        /**
         * Sets the broker URL to use to connect to ActiveMQ. If none configured
         * then localhost:61616 is used by default (however can be overridden by
         * configuration from environment variables).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param brokerURL the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder brokerURL(java.lang.String brokerURL) {
            doSetProperty("brokerURL", brokerURL);
            return this;
        }
    
        /**
         * Sets the JMS client ID to use. Note that this value, if specified,
         * must be unique and can only be used by a single JMS connection
         * instance. It is typically only required for durable topic
         * subscriptions with JMS 1.1.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder clientId(java.lang.String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
    
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option is a:
         * &lt;code&gt;jakarta.jms.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder connectionFactory(jakarta.jms.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
    
        
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder disableReplyTo(boolean disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
    
        /**
         * The durable subscriber name for specifying durable topic
         * subscriptions. The clientId option must be configured as well.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param durableSubscriptionName the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder durableSubscriptionName(java.lang.String durableSubscriptionName) {
            doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }
    
        
        /**
         * Use an embedded in-memory (non-persistent) ActiveMQ broker for
         * development and testing purposes. You must have activemq-broker JAR
         * on the classpath.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param embedded the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder embedded(boolean embedded) {
            doSetProperty("embedded", embedded);
            return this;
        }
    
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.JmsMessageType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder jmsMessageType(org.apache.camel.component.jms.JmsMessageType jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
    
        /**
         * Provides an explicit ReplyTo destination (overrides any incoming
         * value of Message.getJMSReplyTo() in consumer).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param replyTo the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyTo(java.lang.String replyTo) {
            doSetProperty("replyTo", replyTo);
            return this;
        }
    
        
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder testConnectionOnStartup(boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
    
        
        /**
         * Enables or disables whether a PooledConnectionFactory will be used so
         * that when messages are sent to ActiveMQ from outside a message
         * consuming thread, pooling will be used rather than the default with
         * the Spring JmsTemplate which will create a new connection, session,
         * producer for each message then close them all down again. The default
         * value is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param usePooledConnection the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder usePooledConnection(boolean usePooledConnection) {
            doSetProperty("usePooledConnection", usePooledConnection);
            return this;
        }
    
        
        /**
         * Enables or disables whether a Spring SingleConnectionFactory will be
         * used so that when messages are sent to ActiveMQ from outside a
         * message consuming thread, pooling will be used rather than the
         * default with the Spring JmsTemplate which will create a new
         * connection, session, producer for each message then close them all
         * down again. The default value is false and a pooled connection is
         * used by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param useSingleConnection the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder useSingleConnection(boolean useSingleConnection) {
            doSetProperty("useSingleConnection", useSingleConnection);
            return this;
        }
    
        
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: consumer
         * 
         * @param acknowledgementModeName the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder acknowledgementModeName(java.lang.String acknowledgementModeName) {
            doSetProperty("acknowledgementModeName", acknowledgementModeName);
            return this;
        }
    
        /**
         * Consumer priorities allow you to ensure that high priority consumers
         * receive messages while they are active. Normally, active consumers
         * connected to a queue receive messages from it in a round-robin
         * fashion. When consumer priorities are in use, messages are delivered
         * round-robin if multiple active consumers exist with the same high
         * priority. Messages will only going to lower priority consumers when
         * the high priority consumers do not have credit available to consume
         * the message, or those high priority consumers have declined to accept
         * the message (for instance because it does not meet the criteria of
         * any selectors associated with the consumer).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param artemisConsumerPriority the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder artemisConsumerPriority(int artemisConsumerPriority) {
            doSetProperty("artemisConsumerPriority", artemisConsumerPriority);
            return this;
        }
    
        
        /**
         * Whether the JmsConsumer processes the Exchange asynchronously. If
         * enabled then the JmsConsumer may pickup the next message from the JMS
         * queue, while the previous message is being processed asynchronously
         * (by the Asynchronous Routing Engine). This means that messages may be
         * processed not 100% strictly in order. If disabled (as default) then
         * the Exchange is fully processed before the JmsConsumer will pickup
         * the next message from the JMS queue. Note if transacted has been
         * enabled, then asyncConsumer=true does not run asynchronously, as
         * transaction must be executed synchronously.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param asyncConsumer the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder asyncConsumer(boolean asyncConsumer) {
            doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }
    
        
        /**
         * Specifies whether the consumer container should auto-startup.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoStartup the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder autoStartup(boolean autoStartup) {
            doSetProperty("autoStartup", autoStartup);
            return this;
        }
    
        /**
         * Sets the cache level by ID for the underlying JMS resources. See
         * cacheLevelName option for more details.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param cacheLevel the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder cacheLevel(int cacheLevel) {
            doSetProperty("cacheLevel", cacheLevel);
            return this;
        }
    
        
        /**
         * Sets the cache level by name for the underlying JMS resources.
         * Possible values are: CACHE_AUTO, CACHE_CONNECTION, CACHE_CONSUMER,
         * CACHE_NONE, and CACHE_SESSION. The default setting is CACHE_AUTO. See
         * the Spring documentation and Transactions Cache Levels for more
         * information.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: CACHE_AUTO
         * Group: consumer
         * 
         * @param cacheLevelName the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder cacheLevelName(java.lang.String cacheLevelName) {
            doSetProperty("cacheLevelName", cacheLevelName);
            return this;
        }
    
        
        /**
         * Specifies the default number of concurrent consumers when consuming
         * from JMS (not for request/reply over JMS). See also the
         * maxMessagesPerTask option to control dynamic scaling up/down of
         * threads. When doing request/reply over JMS then the option
         * replyToConcurrentConsumers is used to control number of concurrent
         * consumers on the reply message listener.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder concurrentConsumers(int concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
    
        /**
         * Specifies the maximum number of concurrent consumers when consuming
         * from JMS (not for request/reply over JMS). See also the
         * maxMessagesPerTask option to control dynamic scaling up/down of
         * threads. When doing request/reply over JMS then the option
         * replyToMaxConcurrentConsumers is used to control number of concurrent
         * consumers on the reply message listener.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder maxConcurrentConsumers(int maxConcurrentConsumers) {
            doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }
    
        
        /**
         * Specifies whether to use persistent delivery by default for replies.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param replyToDeliveryPersistent the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
            doSetProperty("replyToDeliveryPersistent", replyToDeliveryPersistent);
            return this;
        }
    
        /**
         * Sets the JMS selector to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param selector the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder selector(java.lang.String selector) {
            doSetProperty("selector", selector);
            return this;
        }
    
        
        /**
         * Set whether to make the subscription durable. The durable
         * subscription name to be used can be specified through the
         * subscriptionName property. Default is false. Set this to true to
         * register a durable subscription, typically in combination with a
         * subscriptionName value (unless your message listener class name is
         * good enough as subscription name). Only makes sense when listening to
         * a topic (pub-sub domain), therefore this method switches the
         * pubSubDomain flag as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param subscriptionDurable the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder subscriptionDurable(boolean subscriptionDurable) {
            doSetProperty("subscriptionDurable", subscriptionDurable);
            return this;
        }
    
        /**
         * Set the name of a subscription to create. To be applied in case of a
         * topic (pub-sub domain) with a shared or durable subscription. The
         * subscription name needs to be unique within this client's JMS client
         * id. Default is the class name of the specified message listener.
         * Note: Only 1 concurrent consumer (which is the default of this
         * message listener container) is allowed for each subscription, except
         * for a shared subscription (which requires JMS 2.0).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param subscriptionName the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder subscriptionName(java.lang.String subscriptionName) {
            doSetProperty("subscriptionName", subscriptionName);
            return this;
        }
    
        
        /**
         * Set whether to make the subscription shared. The shared subscription
         * name to be used can be specified through the subscriptionName
         * property. Default is false. Set this to true to register a shared
         * subscription, typically in combination with a subscriptionName value
         * (unless your message listener class name is good enough as
         * subscription name). Note that shared subscriptions may also be
         * durable, so this flag can (and often will) be combined with
         * subscriptionDurable as well. Only makes sense when listening to a
         * topic (pub-sub domain), therefore this method switches the
         * pubSubDomain flag as well. Requires a JMS 2.0 compatible message
         * broker.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param subscriptionShared the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder subscriptionShared(boolean subscriptionShared) {
            doSetProperty("subscriptionShared", subscriptionShared);
            return this;
        }
    
        
        /**
         * Specifies whether the consumer accept messages while it is stopping.
         * You may consider enabling this option, if you start and stop JMS
         * routes at runtime, while there are still messages enqueued on the
         * queue. If this option is false, and you stop the JMS route, then
         * messages may be rejected, and the JMS broker would have to attempt
         * redeliveries, which yet again may be rejected, and eventually the
         * message may be moved at a dead letter queue on the JMS broker. To
         * avoid this its recommended to enable this option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param acceptMessagesWhileStopping the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder acceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
            doSetProperty("acceptMessagesWhileStopping", acceptMessagesWhileStopping);
            return this;
        }
    
        
        /**
         * Whether the DefaultMessageListenerContainer used in the reply
         * managers for request-reply messaging allow the
         * DefaultMessageListenerContainer.runningAllowed flag to quick stop in
         * case JmsConfiguration#isAcceptMessagesWhileStopping is enabled, and
         * org.apache.camel.CamelContext is currently being stopped. This quick
         * stop ability is enabled by default in the regular JMS consumers but
         * to enable for reply managers you must enable this flag.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param allowReplyManagerQuickStop the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder allowReplyManagerQuickStop(boolean allowReplyManagerQuickStop) {
            doSetProperty("allowReplyManagerQuickStop", allowReplyManagerQuickStop);
            return this;
        }
    
        
        /**
         * The consumer type to use, which can be one of: Simple, Default, or
         * Custom. The consumer type determines which Spring JMS listener to
         * use. Default will use
         * org.springframework.jms.listener.DefaultMessageListenerContainer,
         * Simple will use
         * org.springframework.jms.listener.SimpleMessageListenerContainer. When
         * Custom is specified, the MessageListenerContainerFactory defined by
         * the messageListenerContainerFactory option will determine what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.ConsumerType&lt;/code&gt;
         * type.
         * 
         * Default: Default
         * Group: consumer (advanced)
         * 
         * @param consumerType the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder consumerType(org.apache.camel.component.jms.ConsumerType consumerType) {
            doSetProperty("consumerType", consumerType);
            return this;
        }
    
        /**
         * Specifies what default TaskExecutor type to use in the
         * DefaultMessageListenerContainer, for both consumer endpoints and the
         * ReplyTo consumer of producer endpoints. Possible values: SimpleAsync
         * (uses Spring's SimpleAsyncTaskExecutor) or ThreadPool (uses Spring's
         * ThreadPoolTaskExecutor with optimal values - cached
         * thread-pool-like). If not set, it defaults to the previous behaviour,
         * which uses a cached thread pool for consumer endpoints and
         * SimpleAsync for reply consumers. The use of ThreadPool is recommended
         * to reduce thread trash in elastic configurations with dynamically
         * increasing and decreasing concurrent consumers.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.DefaultTaskExecutorType&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param defaultTaskExecutorType the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder defaultTaskExecutorType(org.apache.camel.component.jms.DefaultTaskExecutorType defaultTaskExecutorType) {
            doSetProperty("defaultTaskExecutorType", defaultTaskExecutorType);
            return this;
        }
    
        
        /**
         * Enables eager loading of JMS properties and payload as soon as a
         * message is loaded which generally is inefficient as the JMS
         * properties may not be required but sometimes can catch early any
         * issues with the underlying JMS provider and the use of JMS
         * properties. See also the option eagerPoisonBody.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param eagerLoadingOfProperties the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder eagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
            doSetProperty("eagerLoadingOfProperties", eagerLoadingOfProperties);
            return this;
        }
    
        
        /**
         * If eagerLoadingOfProperties is enabled and the JMS message payload
         * (JMS body or JMS properties) is poison (cannot be read/mapped), then
         * set this text as the message body instead so the message can be
         * processed (the cause of the poison are already stored as exception on
         * the Exchange). This can be turned off by setting
         * eagerPoisonBody=false. See also the option eagerLoadingOfProperties.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Poison JMS message due to ${exception.message}
         * Group: consumer (advanced)
         * 
         * @param eagerPoisonBody the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder eagerPoisonBody(java.lang.String eagerPoisonBody) {
            doSetProperty("eagerPoisonBody", eagerPoisonBody);
            return this;
        }
    
        
        /**
         * Specifies whether the listener session should be exposed when
         * consuming messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param exposeListenerSession the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder exposeListenerSession(boolean exposeListenerSession) {
            doSetProperty("exposeListenerSession", exposeListenerSession);
            return this;
        }
    
        
        /**
         * The consumer type of the reply consumer (when doing request/reply),
         * which can be one of: Simple, Default, or Custom. The consumer type
         * determines which Spring JMS listener to use. Default will use
         * org.springframework.jms.listener.DefaultMessageListenerContainer,
         * Simple will use
         * org.springframework.jms.listener.SimpleMessageListenerContainer. When
         * Custom is specified, the MessageListenerContainerFactory defined by
         * the messageListenerContainerFactory option will determine what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.ConsumerType&lt;/code&gt;
         * type.
         * 
         * Default: Default
         * Group: consumer (advanced)
         * 
         * @param replyToConsumerType the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyToConsumerType(org.apache.camel.component.jms.ConsumerType replyToConsumerType) {
            doSetProperty("replyToConsumerType", replyToConsumerType);
            return this;
        }
    
        
        /**
         * Whether a JMS consumer is allowed to send a reply message to the same
         * destination that the consumer is using to consume from. This prevents
         * an endless loop by consuming and sending back the same message to
         * itself.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param replyToSameDestinationAllowed the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyToSameDestinationAllowed(boolean replyToSameDestinationAllowed) {
            doSetProperty("replyToSameDestinationAllowed", replyToSameDestinationAllowed);
            return this;
        }
    
        /**
         * Allows you to specify a custom task executor for consuming messages.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.core.task.TaskExecutor&lt;/code&gt;
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param taskExecutor the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder taskExecutor(org.springframework.core.task.TaskExecutor taskExecutor) {
            doSetProperty("taskExecutor", taskExecutor);
            return this;
        }
    
        
        /**
         * Sets delivery delay to use for send calls for JMS. This option
         * requires JMS 2.0 compliant broker.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param deliveryDelay the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder deliveryDelay(long deliveryDelay) {
            doSetProperty("deliveryDelay", deliveryDelay);
            return this;
        }
    
        /**
         * Specifies the delivery mode to be used. Possible values are those
         * defined by jakarta.jms.DeliveryMode. NON_PERSISTENT = 1 and
         * PERSISTENT = 2.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param deliveryMode the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder deliveryMode(java.lang.Integer deliveryMode) {
            doSetProperty("deliveryMode", deliveryMode);
            return this;
        }
    
        
        /**
         * Specifies whether persistent delivery is used by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param deliveryPersistent the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder deliveryPersistent(boolean deliveryPersistent) {
            doSetProperty("deliveryPersistent", deliveryPersistent);
            return this;
        }
    
        
        /**
         * Set if the deliveryMode, priority or timeToLive qualities of service
         * should be used when sending messages. This option is based on
         * Spring's JmsTemplate. The deliveryMode, priority and timeToLive
         * options are applied to the current endpoint. This contrasts with the
         * preserveMessageQos option, which operates at message granularity,
         * reading QoS properties exclusively from the Camel In message headers.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param explicitQosEnabled the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder explicitQosEnabled(java.lang.Boolean explicitQosEnabled) {
            doSetProperty("explicitQosEnabled", explicitQosEnabled);
            return this;
        }
    
        
        /**
         * Sets whether JMS date properties should be formatted according to the
         * ISO 8601 standard.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param formatDateHeadersToIso8601 the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder formatDateHeadersToIso8601(boolean formatDateHeadersToIso8601) {
            doSetProperty("formatDateHeadersToIso8601", formatDateHeadersToIso8601);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Set to true, if you want to send message using the QoS settings
         * specified on the message, instead of the QoS settings on the JMS
         * endpoint. The following three headers are considered JMSPriority,
         * JMSDeliveryMode, and JMSExpiration. You can provide all or only some
         * of them. If not provided, Camel will fall back to use the values from
         * the endpoint instead. So, when using this option, the headers
         * override the values from the endpoint. The explicitQosEnabled option,
         * by contrast, will only use options set on the endpoint, and not
         * values from the message header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param preserveMessageQos the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder preserveMessageQos(boolean preserveMessageQos) {
            doSetProperty("preserveMessageQos", preserveMessageQos);
            return this;
        }
    
        
        /**
         * Values greater than 1 specify the message priority when sending
         * (where 1 is the lowest priority and 9 is the highest). The
         * explicitQosEnabled option must also be enabled in order for this
         * option to have any effect.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4
         * Group: producer
         * 
         * @param priority the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder priority(int priority) {
            doSetProperty("priority", priority);
            return this;
        }
    
        
        /**
         * Specifies the default number of concurrent consumers when doing
         * request/reply over JMS. See also the maxMessagesPerTask option to
         * control dynamic scaling up/down of threads.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param replyToConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyToConcurrentConsumers(int replyToConcurrentConsumers) {
            doSetProperty("replyToConcurrentConsumers", replyToConcurrentConsumers);
            return this;
        }
    
        /**
         * Specifies the maximum number of concurrent consumers when using
         * request/reply over JMS. See also the maxMessagesPerTask option to
         * control dynamic scaling up/down of threads.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyToMaxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyToMaxConcurrentConsumers(int replyToMaxConcurrentConsumers) {
            doSetProperty("replyToMaxConcurrentConsumers", replyToMaxConcurrentConsumers);
            return this;
        }
    
        
        /**
         * Specifies the maximum number of concurrent consumers for continue
         * routing when timeout occurred when using request/reply over JMS.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param replyToOnTimeoutMaxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyToOnTimeoutMaxConcurrentConsumers(int replyToOnTimeoutMaxConcurrentConsumers) {
            doSetProperty("replyToOnTimeoutMaxConcurrentConsumers", replyToOnTimeoutMaxConcurrentConsumers);
            return this;
        }
    
        /**
         * Provides an explicit ReplyTo destination in the JMS message, which
         * overrides the setting of replyTo. It is useful if you want to forward
         * the message to a remote Queue and receive the reply message from the
         * ReplyTo destination.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyToOverride the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyToOverride(java.lang.String replyToOverride) {
            doSetProperty("replyToOverride", replyToOverride);
            return this;
        }
    
        /**
         * Allows for explicitly specifying which kind of strategy to use for
         * replyTo queues when doing request/reply over JMS. Possible values
         * are: Temporary, Shared, or Exclusive. By default Camel will use
         * temporary queues. However if replyTo has been configured, then Shared
         * is used by default. This option allows you to use exclusive queues
         * instead of shared ones. See Camel JMS documentation for more details,
         * and especially the notes about the implications if running in a
         * clustered environment, and the fact that Shared reply queues has
         * lower performance than its alternatives Temporary and Exclusive.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.ReplyToType&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param replyToType the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyToType(org.apache.camel.component.jms.ReplyToType replyToType) {
            doSetProperty("replyToType", replyToType);
            return this;
        }
    
        
        /**
         * The timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds). The default is 20 seconds. You can include
         * the header CamelJmsRequestTimeout to override this endpoint
         * configured timeout value, and thus have per message individual
         * timeout values. See also the requestTimeoutCheckerInterval option.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder requestTimeout(long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
    
        
        /**
         * When sending messages, specifies the time-to-live of the message (in
         * milliseconds).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder timeToLive(long timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
    
        /**
         * This option is used to allow additional headers which may have values
         * that are invalid according to JMS specification. For example, some
         * message systems, such as WMQ, do this with header names using prefix
         * JMS_IBM_MQMD_ containing values with byte array or other invalid
         * types. You can specify multiple header names separated by comma, and
         * use as suffix for wildcard matching.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param allowAdditionalHeaders the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder allowAdditionalHeaders(java.lang.String allowAdditionalHeaders) {
            doSetProperty("allowAdditionalHeaders", allowAdditionalHeaders);
            return this;
        }
    
        
        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an JMSException is thrown.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param allowNullBody the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder allowNullBody(boolean allowNullBody) {
            doSetProperty("allowNullBody", allowNullBody);
            return this;
        }
    
        
        /**
         * If true, Camel will always make a JMS message copy of the message
         * when it is passed to the producer for sending. Copying the message is
         * needed in some situations, such as when a
         * replyToDestinationSelectorName is set (incidentally, Camel will set
         * the alwaysCopyMessage option to true, if a
         * replyToDestinationSelectorName is set).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param alwaysCopyMessage the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder alwaysCopyMessage(boolean alwaysCopyMessage) {
            doSetProperty("alwaysCopyMessage", alwaysCopyMessage);
            return this;
        }
    
        /**
         * When using InOut exchange pattern use this JMS property instead of
         * JMSCorrelationID JMS property to correlate messages. If set messages
         * will be correlated solely on the value of this property
         * JMSCorrelationID property will be ignored and not set by Camel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param correlationProperty the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder correlationProperty(java.lang.String correlationProperty) {
            doSetProperty("correlationProperty", correlationProperty);
            return this;
        }
    
        
        /**
         * Use this option to force disabling time to live. For example when you
         * do request/reply over JMS, then Camel will by default use the
         * requestTimeout value as time to live on the message being sent. The
         * problem is that the sender and receiver systems have to have their
         * clocks synchronized, so they are in sync. This is not always so easy
         * to archive. So you can use disableTimeToLive=true to not set a time
         * to live value on the sent message. Then the message will not expire
         * on the receiver system. See below in section About time to live for
         * more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param disableTimeToLive the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder disableTimeToLive(boolean disableTimeToLive) {
            doSetProperty("disableTimeToLive", disableTimeToLive);
            return this;
        }
    
        
        /**
         * When using mapJmsMessage=false Camel will create a new JMS message to
         * send to a new JMS destination if you touch the headers (get or set)
         * during the route. Set this option to true to force Camel to send the
         * original JMS message that was received.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param forceSendOriginalMessage the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder forceSendOriginalMessage(boolean forceSendOriginalMessage) {
            doSetProperty("forceSendOriginalMessage", forceSendOriginalMessage);
            return this;
        }
    
        
        /**
         * Only applicable when sending to JMS destination using InOnly (eg fire
         * and forget). Enabling this option will enrich the Camel Exchange with
         * the actual JMSMessageID that was used by the JMS client when the
         * message was sent to the JMS destination.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param includeSentJMSMessageID the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder includeSentJMSMessageID(boolean includeSentJMSMessageID) {
            doSetProperty("includeSentJMSMessageID", includeSentJMSMessageID);
            return this;
        }
    
        /**
         * Sets the cache level by name for the reply consumer when doing
         * request/reply over JMS. This option only applies when using fixed
         * reply queues (not temporary). Camel will by default use:
         * CACHE_CONSUMER for exclusive or shared w/ replyToSelectorName. And
         * CACHE_SESSION for shared without replyToSelectorName. Some JMS
         * brokers such as IBM WebSphere may require to set the
         * replyToCacheLevelName=CACHE_NONE to work. Note: If using temporary
         * queues then CACHE_NONE is not allowed, and you must use a higher
         * value such as CACHE_CONSUMER or CACHE_SESSION.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param replyToCacheLevelName the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyToCacheLevelName(java.lang.String replyToCacheLevelName) {
            doSetProperty("replyToCacheLevelName", replyToCacheLevelName);
            return this;
        }
    
        /**
         * Sets the JMS Selector using the fixed name to be used so you can
         * filter out your own replies from the others when using a shared queue
         * (that is, if you are not using a temporary reply queue).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param replyToDestinationSelectorName the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder replyToDestinationSelectorName(java.lang.String replyToDestinationSelectorName) {
            doSetProperty("replyToDestinationSelectorName", replyToDestinationSelectorName);
            return this;
        }
    
        
        /**
         * Sets whether StreamMessage type is enabled or not. Message payloads
         * of streaming kind such as files, InputStream, etc will either by sent
         * as BytesMessage or StreamMessage. This option controls which kind
         * will be used. By default BytesMessage is used which enforces the
         * entire message payload to be read into memory. By enabling this
         * option the message payload is read into memory in chunks and each
         * chunk is then written to the StreamMessage until no more data.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param streamMessageTypeEnabled the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder streamMessageTypeEnabled(boolean streamMessageTypeEnabled) {
            doSetProperty("streamMessageTypeEnabled", streamMessageTypeEnabled);
            return this;
        }
    
        
        /**
         * Whether to auto-discover ConnectionFactory from the registry, if no
         * connection factory has been configured. If only one instance of
         * ConnectionFactory is found then it will be used. This is enabled by
         * default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param allowAutoWiredConnectionFactory the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder allowAutoWiredConnectionFactory(boolean allowAutoWiredConnectionFactory) {
            doSetProperty("allowAutoWiredConnectionFactory", allowAutoWiredConnectionFactory);
            return this;
        }
    
        
        /**
         * Whether to auto-discover DestinationResolver from the registry, if no
         * destination resolver has been configured. If only one instance of
         * DestinationResolver is found then it will be used. This is enabled by
         * default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param allowAutoWiredDestinationResolver the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder allowAutoWiredDestinationResolver(boolean allowAutoWiredDestinationResolver) {
            doSetProperty("allowAutoWiredDestinationResolver", allowAutoWiredDestinationResolver);
            return this;
        }
    
        
        /**
         * Controls whether or not to include serialized headers. Applies only
         * when transferExchange is true. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
    
        
        /**
         * Whether optimizing for Apache Artemis streaming mode. This can reduce
         * memory overhead when using Artemis with JMS StreamMessage types. This
         * option must only be enabled if Apache Artemis is being used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param artemisStreamingEnabled the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder artemisStreamingEnabled(boolean artemisStreamingEnabled) {
            doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }
    
        
        /**
         * Whether to startup the JmsConsumer message listener asynchronously,
         * when starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail-over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder asyncStartListener(boolean asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
    
        
        /**
         * Whether to stop the JmsConsumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder asyncStopListener(boolean asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        
        /**
         * Maximum number of messages to keep in memory available for browsing.
         * Use 0 for unlimited.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param browseLimit the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder browseLimit(int browseLimit) {
            doSetProperty("browseLimit", browseLimit);
            return this;
        }
    
        /**
         * To use a shared JMS configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.JmsConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder configuration(org.apache.camel.component.jms.JmsConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * A pluggable
         * org.springframework.jms.support.destination.DestinationResolver that
         * allows you to use your own resolver (for example, to lookup the real
         * destination in a JNDI registry).
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.jms.support.destination.DestinationResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationResolver the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder destinationResolver(org.springframework.jms.support.destination.DestinationResolver destinationResolver) {
            doSetProperty("destinationResolver", destinationResolver);
            return this;
        }
    
        /**
         * Specifies a org.springframework.util.ErrorHandler to be invoked in
         * case of any uncaught exceptions thrown while processing a Message. By
         * default these exceptions will be logged at the WARN level, if no
         * errorHandler has been configured. You can configure logging level and
         * whether stack traces should be logged using errorHandlerLoggingLevel
         * and errorHandlerLogStackTrace options. This makes it much easier to
         * configure, than having to code a custom errorHandler.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.util.ErrorHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param errorHandler the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder errorHandler(org.springframework.util.ErrorHandler errorHandler) {
            doSetProperty("errorHandler", errorHandler);
            return this;
        }
    
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a:
         * &lt;code&gt;jakarta.jms.ExceptionListener&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder exceptionListener(jakarta.jms.ExceptionListener exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
    
        
        /**
         * Specify the limit for the number of consumers that are allowed to be
         * idle at any given time.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleConsumerLimit the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder idleConsumerLimit(int idleConsumerLimit) {
            doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }
    
        /**
         * Marks the consumer as idle after the specified number of idle
         * receives have been reached. An idle receive is counted from the
         * moment a null message is returned by the receiver after the potential
         * setReceiveTimeout elapsed. This gives the opportunity to check if the
         * idle task count exceeds setIdleTaskExecutionLimit and based on that
         * decide if the task needs to be re-scheduled or not, saving resources
         * that would otherwise be held. This setting differs from
         * setMaxMessagesPerTask where the task is released and re-scheduled
         * after this limit is reached, no matter if the received messages were
         * null or non-null messages. This setting alone can be inflexible if
         * one desires to have a large enough batch for each task but requires a
         * quick(er) release from the moment there are no more messages to
         * process. This setting differs from setIdleTaskExecutionLimit where
         * this limit decides after how many iterations of being marked as idle,
         * a task is released. For example: If setMaxMessagesPerTask is set to
         * '500' and #setIdleReceivesPerTaskLimit is set to '60' and
         * setReceiveTimeout is set to '1000' and setIdleTaskExecutionLimit is
         * set to '1', then 500 messages per task would be processed unless
         * there is a subsequent number of 60 idle messages received, the task
         * would be marked as idle and released. This also means that after the
         * last message was processed, the task would be released after 60
         * seconds as long as no new messages appear.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param idleReceivesPerTaskLimit the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder idleReceivesPerTaskLimit(int idleReceivesPerTaskLimit) {
            doSetProperty("idleReceivesPerTaskLimit", idleReceivesPerTaskLimit);
            return this;
        }
    
        
        /**
         * Specifies the limit for idle executions of a receive task, not having
         * received any message within its execution. If this limit is reached,
         * the task will shut down and leave receiving to other executing tasks
         * (in the case of dynamic scheduling; see the maxConcurrentConsumers
         * setting). There is additional doc available from Spring.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleTaskExecutionLimit the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder idleTaskExecutionLimit(int idleTaskExecutionLimit) {
            doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }
    
        
        /**
         * Whether to include all JMSX prefixed properties when mapping from JMS
         * to Camel Message. Setting this to true will include properties such
         * as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder includeAllJMSXProperties(boolean includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
    
        
        /**
         * Whether the JMS consumer should include JMSCorrelationIDAsBytes as a
         * header on the Camel Message.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param includeCorrelationIDAsBytes the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder includeCorrelationIDAsBytes(boolean includeCorrelationIDAsBytes) {
            doSetProperty("includeCorrelationIDAsBytes", includeCorrelationIDAsBytes);
            return this;
        }
    
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder jmsKeyFormatStrategy(org.apache.camel.component.jms.JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
    
        
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder mapJmsMessage(boolean mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
    
        
        /**
         * The number of messages per task. -1 is unlimited. If you use a range
         * for concurrent consumers (eg min max), then this option can be used
         * to set a value to eg 100 to control how fast the consumers will
         * shrink when less work is required.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxMessagesPerTask the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder maxMessagesPerTask(int maxMessagesPerTask) {
            doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }
    
        /**
         * To use a custom Spring
         * org.springframework.jms.support.converter.MessageConverter so you can
         * be in control how to map to/from a jakarta.jms.Message.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.jms.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder messageConverter(org.springframework.jms.support.converter.MessageConverter messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
    
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder messageCreatedStrategy(org.apache.camel.component.jms.MessageCreatedStrategy messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
    
        
        /**
         * When sending, specifies whether message IDs should be added. This is
         * just an hint to the JMS broker. If the JMS provider accepts this
         * hint, these messages must have the message ID set to null; if the
         * provider ignores the hint, the message ID must be set to its normal
         * unique value.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageIdEnabled the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder messageIdEnabled(boolean messageIdEnabled) {
            doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }
    
        /**
         * Registry ID of the MessageListenerContainerFactory used to determine
         * what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use to consume messages. Setting this will automatically set
         * consumerType to Custom.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.MessageListenerContainerFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageListenerContainerFactory the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder messageListenerContainerFactory(org.apache.camel.component.jms.MessageListenerContainerFactory messageListenerContainerFactory) {
            doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }
    
        
        /**
         * Specifies whether timestamps should be enabled by default on sending
         * messages. This is just an hint to the JMS broker. If the JMS provider
         * accepts this hint, these messages must have the timestamp set to
         * zero; if the provider ignores the hint the timestamp must be set to
         * its normal value.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageTimestampEnabled the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder messageTimestampEnabled(boolean messageTimestampEnabled) {
            doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }
    
        
        /**
         * Specifies whether to inhibit the delivery of messages published by
         * its own connection.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param pubSubNoLocal the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder pubSubNoLocal(boolean pubSubNoLocal) {
            doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }
    
        /**
         * To use a custom QueueBrowseStrategy when browsing queues.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.QueueBrowseStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param queueBrowseStrategy the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder queueBrowseStrategy(org.apache.camel.component.jms.QueueBrowseStrategy queueBrowseStrategy) {
            doSetProperty("queueBrowseStrategy", queueBrowseStrategy);
            return this;
        }
    
        
        /**
         * The timeout for receiving messages (in milliseconds).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder receiveTimeout(long receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
    
        
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder recoveryInterval(long recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
    
        
        /**
         * Configures how often Camel should check for timed out Exchanges when
         * doing request/reply over JMS. By default Camel checks once per
         * second. But if you must react faster when a timeout occurs, then you
         * can lower this interval, to check more frequently. The timeout is
         * determined by the option requestTimeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder requestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
    
        
        /**
         * Whether to detect the network address location of the JMS broker on
         * startup. This information is gathered via reflection on the
         * ConnectionFactory, and is vendor specific. This option can be used to
         * turn this off.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param serviceLocationEnabled the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder serviceLocationEnabled(boolean serviceLocationEnabled) {
            doSetProperty("serviceLocationEnabled", serviceLocationEnabled);
            return this;
        }
    
        
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    
        /**
         * A pluggable TemporaryQueueResolver that allows you to use your own
         * resolver for creating temporary queues (some messaging systems has
         * special requirements for creating temporary queues).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.TemporaryQueueResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param temporaryQueueResolver the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder temporaryQueueResolver(org.apache.camel.component.jms.TemporaryQueueResolver temporaryQueueResolver) {
            doSetProperty("temporaryQueueResolver", temporaryQueueResolver);
            return this;
        }
    
        
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder transferException(boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
    
        
        /**
         * You can transfer the exchange over the wire instead of just the body
         * and headers. The following fields are transferred: In body, Out body,
         * Fault body, In headers, Out headers, Fault headers, exchange
         * properties, exchange exception. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level. You must enable this option on both the producer
         * and consumer side, so Camel knows the payloads is an Exchange and not
         * a regular payload. Use this with caution as the data is using Java
         * Object serialization and requires the receiver to be able to
         * deserialize the data at Class level, which forces a strong coupling
         * between the producers and consumers having to use compatible Camel
         * versions!.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder transferExchange(boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
    
        
        /**
         * Define if all Java packages are trusted or not (for Java object JMS
         * message types). Notice its not recommended practice to send Java
         * serialized objects over network. Setting this to true can expose
         * security risks, so use this with care.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param trustAllPackages the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder trustAllPackages(boolean trustAllPackages) {
            doSetProperty("trustAllPackages", trustAllPackages);
            return this;
        }
    
        
        /**
         * Specifies whether JMSMessageID should always be used as
         * JMSCorrelationID for InOut messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useMessageIDAsCorrelationID the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder useMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
            doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }
    
        
        /**
         * Number of times to wait for provisional correlation id to be updated
         * to the actual correlation id when doing request/reply over JMS and
         * when the option useMessageIDAsCorrelationID is enabled.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedCounter the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder waitForProvisionCorrelationToBeUpdatedCounter(int waitForProvisionCorrelationToBeUpdatedCounter) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }
    
        
        /**
         * Interval in millis to sleep each time while waiting for provisional
         * correlation id to be updated.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedThreadSleepingTime the
         * value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }
    
        
        /**
         * Number of times to wait for temporary replyTo queue to be created and
         * ready when doing request/reply over JMS.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 200
         * Group: advanced
         * 
         * @param waitForTemporaryReplyToToBeUpdatedCounter the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder waitForTemporaryReplyToToBeUpdatedCounter(int waitForTemporaryReplyToToBeUpdatedCounter) {
            doSetProperty("waitForTemporaryReplyToToBeUpdatedCounter", waitForTemporaryReplyToToBeUpdatedCounter);
            return this;
        }
    
        
        /**
         * Interval in millis to sleep each time while waiting for temporary
         * replyTo queue to be ready.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param waitForTemporaryReplyToToBeUpdatedThreadSleepingTime the value
         * to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder waitForTemporaryReplyToToBeUpdatedThreadSleepingTime(long waitForTemporaryReplyToToBeUpdatedThreadSleepingTime) {
            doSetProperty("waitForTemporaryReplyToToBeUpdatedThreadSleepingTime", waitForTemporaryReplyToToBeUpdatedThreadSleepingTime);
            return this;
        }
    
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * header to and from Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
    
        
        /**
         * Allows to configure the default errorHandler logging level for
         * logging uncaught exceptions.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: logging
         * 
         * @param errorHandlerLoggingLevel the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder errorHandlerLoggingLevel(org.apache.camel.LoggingLevel errorHandlerLoggingLevel) {
            doSetProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }
    
        
        /**
         * Allows to control whether stack-traces should be logged or not, by
         * the default errorHandler.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: logging
         * 
         * @param errorHandlerLogStackTrace the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder errorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
            doSetProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }
    
        /**
         * Password to use with the ConnectionFactory. You can also configure
         * username/password directly on the ConnectionFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder password(java.lang.String password) {
            doSetProperty("password", password);
            return this;
        }
    
        /**
         * Username to use with the ConnectionFactory. You can also configure
         * username/password directly on the ConnectionFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder username(java.lang.String username) {
            doSetProperty("username", username);
            return this;
        }
    
        
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
    
        
        /**
         * Specifies whether InOut operations (request reply) default to using
         * transacted mode If this flag is set to true, then Spring JmsTemplate
         * will have sessionTransacted set to true, and the acknowledgeMode as
         * transacted on the JmsTemplate used for InOut operations. Note from
         * Spring JMS: that within a JTA transaction, the parameters passed to
         * createQueue, createTopic methods are not taken into account.
         * Depending on the Java EE transaction context, the container makes its
         * own decisions on these values. Analogously, these parameters are not
         * taken into account within a locally managed transaction either, since
         * Spring JMS operates on an existing JMS Session in this case. Setting
         * this flag to true will use a short local JMS transaction when running
         * outside of a managed transaction, and a synchronized local JMS
         * transaction in case of a managed transaction (other than an XA
         * transaction) being present. This has the effect of a local JMS
         * transaction being managed alongside the main transaction (which might
         * be a native JDBC transaction), with the JMS transaction committing
         * right after the main transaction.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transactedInOut the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder transactedInOut(boolean transactedInOut) {
            doSetProperty("transactedInOut", transactedInOut);
            return this;
        }
    
        
        /**
         * If true, Camel will create a JmsTransactionManager, if there is no
         * transactionManager injected when option transacted=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param lazyCreateTransactionManager the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder lazyCreateTransactionManager(boolean lazyCreateTransactionManager) {
            doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }
    
        /**
         * The Spring transaction manager to use.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.transaction.PlatformTransactionManager&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionManager the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder transactionManager(org.springframework.transaction.PlatformTransactionManager transactionManager) {
            doSetProperty("transactionManager", transactionManager);
            return this;
        }
    
        /**
         * The name of the transaction to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionName the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder transactionName(java.lang.String transactionName) {
            doSetProperty("transactionName", transactionName);
            return this;
        }
    
        
        /**
         * The timeout value of the transaction (in seconds), if using
         * transacted mode.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: transaction (advanced)
         * 
         * @param transactionTimeout the value to set
         * @return the dsl builder
         */
        default Activemq6ComponentBuilder transactionTimeout(int transactionTimeout) {
            doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
    }

    class Activemq6ComponentBuilderImpl
            extends AbstractComponentBuilder<ActiveMQComponent>
            implements Activemq6ComponentBuilder {
        @Override
        protected ActiveMQComponent buildConcreteComponent() {
            return new ActiveMQComponent();
        }
        private org.apache.camel.component.jms.JmsConfiguration getOrCreateConfiguration(ActiveMQComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.jms.JmsConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "brokerURL": ((ActiveMQComponent) component).setBrokerURL((java.lang.String) value); return true;
            case "clientId": getOrCreateConfiguration((ActiveMQComponent) component).setClientId((java.lang.String) value); return true;
            case "connectionFactory": getOrCreateConfiguration((ActiveMQComponent) component).setConnectionFactory((jakarta.jms.ConnectionFactory) value); return true;
            case "disableReplyTo": getOrCreateConfiguration((ActiveMQComponent) component).setDisableReplyTo((boolean) value); return true;
            case "durableSubscriptionName": getOrCreateConfiguration((ActiveMQComponent) component).setDurableSubscriptionName((java.lang.String) value); return true;
            case "embedded": ((ActiveMQComponent) component).setEmbedded((boolean) value); return true;
            case "jmsMessageType": getOrCreateConfiguration((ActiveMQComponent) component).setJmsMessageType((org.apache.camel.component.jms.JmsMessageType) value); return true;
            case "replyTo": getOrCreateConfiguration((ActiveMQComponent) component).setReplyTo((java.lang.String) value); return true;
            case "testConnectionOnStartup": getOrCreateConfiguration((ActiveMQComponent) component).setTestConnectionOnStartup((boolean) value); return true;
            case "usePooledConnection": ((ActiveMQComponent) component).setUsePooledConnection((boolean) value); return true;
            case "useSingleConnection": ((ActiveMQComponent) component).setUseSingleConnection((boolean) value); return true;
            case "acknowledgementModeName": getOrCreateConfiguration((ActiveMQComponent) component).setAcknowledgementModeName((java.lang.String) value); return true;
            case "artemisConsumerPriority": getOrCreateConfiguration((ActiveMQComponent) component).setArtemisConsumerPriority((int) value); return true;
            case "asyncConsumer": getOrCreateConfiguration((ActiveMQComponent) component).setAsyncConsumer((boolean) value); return true;
            case "autoStartup": getOrCreateConfiguration((ActiveMQComponent) component).setAutoStartup((boolean) value); return true;
            case "cacheLevel": getOrCreateConfiguration((ActiveMQComponent) component).setCacheLevel((int) value); return true;
            case "cacheLevelName": getOrCreateConfiguration((ActiveMQComponent) component).setCacheLevelName((java.lang.String) value); return true;
            case "concurrentConsumers": getOrCreateConfiguration((ActiveMQComponent) component).setConcurrentConsumers((int) value); return true;
            case "maxConcurrentConsumers": getOrCreateConfiguration((ActiveMQComponent) component).setMaxConcurrentConsumers((int) value); return true;
            case "replyToDeliveryPersistent": getOrCreateConfiguration((ActiveMQComponent) component).setReplyToDeliveryPersistent((boolean) value); return true;
            case "selector": getOrCreateConfiguration((ActiveMQComponent) component).setSelector((java.lang.String) value); return true;
            case "subscriptionDurable": getOrCreateConfiguration((ActiveMQComponent) component).setSubscriptionDurable((boolean) value); return true;
            case "subscriptionName": getOrCreateConfiguration((ActiveMQComponent) component).setSubscriptionName((java.lang.String) value); return true;
            case "subscriptionShared": getOrCreateConfiguration((ActiveMQComponent) component).setSubscriptionShared((boolean) value); return true;
            case "acceptMessagesWhileStopping": getOrCreateConfiguration((ActiveMQComponent) component).setAcceptMessagesWhileStopping((boolean) value); return true;
            case "allowReplyManagerQuickStop": getOrCreateConfiguration((ActiveMQComponent) component).setAllowReplyManagerQuickStop((boolean) value); return true;
            case "consumerType": getOrCreateConfiguration((ActiveMQComponent) component).setConsumerType((org.apache.camel.component.jms.ConsumerType) value); return true;
            case "defaultTaskExecutorType": getOrCreateConfiguration((ActiveMQComponent) component).setDefaultTaskExecutorType((org.apache.camel.component.jms.DefaultTaskExecutorType) value); return true;
            case "eagerLoadingOfProperties": getOrCreateConfiguration((ActiveMQComponent) component).setEagerLoadingOfProperties((boolean) value); return true;
            case "eagerPoisonBody": getOrCreateConfiguration((ActiveMQComponent) component).setEagerPoisonBody((java.lang.String) value); return true;
            case "exposeListenerSession": getOrCreateConfiguration((ActiveMQComponent) component).setExposeListenerSession((boolean) value); return true;
            case "replyToConsumerType": getOrCreateConfiguration((ActiveMQComponent) component).setReplyToConsumerType((org.apache.camel.component.jms.ConsumerType) value); return true;
            case "replyToSameDestinationAllowed": getOrCreateConfiguration((ActiveMQComponent) component).setReplyToSameDestinationAllowed((boolean) value); return true;
            case "taskExecutor": getOrCreateConfiguration((ActiveMQComponent) component).setTaskExecutor((org.springframework.core.task.TaskExecutor) value); return true;
            case "deliveryDelay": getOrCreateConfiguration((ActiveMQComponent) component).setDeliveryDelay((long) value); return true;
            case "deliveryMode": getOrCreateConfiguration((ActiveMQComponent) component).setDeliveryMode((java.lang.Integer) value); return true;
            case "deliveryPersistent": getOrCreateConfiguration((ActiveMQComponent) component).setDeliveryPersistent((boolean) value); return true;
            case "explicitQosEnabled": getOrCreateConfiguration((ActiveMQComponent) component).setExplicitQosEnabled((java.lang.Boolean) value); return true;
            case "formatDateHeadersToIso8601": getOrCreateConfiguration((ActiveMQComponent) component).setFormatDateHeadersToIso8601((boolean) value); return true;
            case "lazyStartProducer": ((ActiveMQComponent) component).setLazyStartProducer((boolean) value); return true;
            case "preserveMessageQos": getOrCreateConfiguration((ActiveMQComponent) component).setPreserveMessageQos((boolean) value); return true;
            case "priority": getOrCreateConfiguration((ActiveMQComponent) component).setPriority((int) value); return true;
            case "replyToConcurrentConsumers": getOrCreateConfiguration((ActiveMQComponent) component).setReplyToConcurrentConsumers((int) value); return true;
            case "replyToMaxConcurrentConsumers": getOrCreateConfiguration((ActiveMQComponent) component).setReplyToMaxConcurrentConsumers((int) value); return true;
            case "replyToOnTimeoutMaxConcurrentConsumers": getOrCreateConfiguration((ActiveMQComponent) component).setReplyToOnTimeoutMaxConcurrentConsumers((int) value); return true;
            case "replyToOverride": getOrCreateConfiguration((ActiveMQComponent) component).setReplyToOverride((java.lang.String) value); return true;
            case "replyToType": getOrCreateConfiguration((ActiveMQComponent) component).setReplyToType((org.apache.camel.component.jms.ReplyToType) value); return true;
            case "requestTimeout": getOrCreateConfiguration((ActiveMQComponent) component).setRequestTimeout((long) value); return true;
            case "timeToLive": getOrCreateConfiguration((ActiveMQComponent) component).setTimeToLive((long) value); return true;
            case "allowAdditionalHeaders": getOrCreateConfiguration((ActiveMQComponent) component).setAllowAdditionalHeaders((java.lang.String) value); return true;
            case "allowNullBody": getOrCreateConfiguration((ActiveMQComponent) component).setAllowNullBody((boolean) value); return true;
            case "alwaysCopyMessage": getOrCreateConfiguration((ActiveMQComponent) component).setAlwaysCopyMessage((boolean) value); return true;
            case "correlationProperty": getOrCreateConfiguration((ActiveMQComponent) component).setCorrelationProperty((java.lang.String) value); return true;
            case "disableTimeToLive": getOrCreateConfiguration((ActiveMQComponent) component).setDisableTimeToLive((boolean) value); return true;
            case "forceSendOriginalMessage": getOrCreateConfiguration((ActiveMQComponent) component).setForceSendOriginalMessage((boolean) value); return true;
            case "includeSentJMSMessageID": getOrCreateConfiguration((ActiveMQComponent) component).setIncludeSentJMSMessageID((boolean) value); return true;
            case "replyToCacheLevelName": getOrCreateConfiguration((ActiveMQComponent) component).setReplyToCacheLevelName((java.lang.String) value); return true;
            case "replyToDestinationSelectorName": getOrCreateConfiguration((ActiveMQComponent) component).setReplyToDestinationSelectorName((java.lang.String) value); return true;
            case "streamMessageTypeEnabled": getOrCreateConfiguration((ActiveMQComponent) component).setStreamMessageTypeEnabled((boolean) value); return true;
            case "allowAutoWiredConnectionFactory": ((ActiveMQComponent) component).setAllowAutoWiredConnectionFactory((boolean) value); return true;
            case "allowAutoWiredDestinationResolver": ((ActiveMQComponent) component).setAllowAutoWiredDestinationResolver((boolean) value); return true;
            case "allowSerializedHeaders": getOrCreateConfiguration((ActiveMQComponent) component).setAllowSerializedHeaders((boolean) value); return true;
            case "artemisStreamingEnabled": getOrCreateConfiguration((ActiveMQComponent) component).setArtemisStreamingEnabled((boolean) value); return true;
            case "asyncStartListener": getOrCreateConfiguration((ActiveMQComponent) component).setAsyncStartListener((boolean) value); return true;
            case "asyncStopListener": getOrCreateConfiguration((ActiveMQComponent) component).setAsyncStopListener((boolean) value); return true;
            case "autowiredEnabled": ((ActiveMQComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "browseLimit": getOrCreateConfiguration((ActiveMQComponent) component).setBrowseLimit((int) value); return true;
            case "configuration": ((ActiveMQComponent) component).setConfiguration((org.apache.camel.component.jms.JmsConfiguration) value); return true;
            case "destinationResolver": getOrCreateConfiguration((ActiveMQComponent) component).setDestinationResolver((org.springframework.jms.support.destination.DestinationResolver) value); return true;
            case "errorHandler": getOrCreateConfiguration((ActiveMQComponent) component).setErrorHandler((org.springframework.util.ErrorHandler) value); return true;
            case "exceptionListener": getOrCreateConfiguration((ActiveMQComponent) component).setExceptionListener((jakarta.jms.ExceptionListener) value); return true;
            case "idleConsumerLimit": getOrCreateConfiguration((ActiveMQComponent) component).setIdleConsumerLimit((int) value); return true;
            case "idleReceivesPerTaskLimit": getOrCreateConfiguration((ActiveMQComponent) component).setIdleReceivesPerTaskLimit((int) value); return true;
            case "idleTaskExecutionLimit": getOrCreateConfiguration((ActiveMQComponent) component).setIdleTaskExecutionLimit((int) value); return true;
            case "includeAllJMSXProperties": getOrCreateConfiguration((ActiveMQComponent) component).setIncludeAllJMSXProperties((boolean) value); return true;
            case "includeCorrelationIDAsBytes": ((ActiveMQComponent) component).setIncludeCorrelationIDAsBytes((boolean) value); return true;
            case "jmsKeyFormatStrategy": getOrCreateConfiguration((ActiveMQComponent) component).setJmsKeyFormatStrategy((org.apache.camel.component.jms.JmsKeyFormatStrategy) value); return true;
            case "mapJmsMessage": getOrCreateConfiguration((ActiveMQComponent) component).setMapJmsMessage((boolean) value); return true;
            case "maxMessagesPerTask": getOrCreateConfiguration((ActiveMQComponent) component).setMaxMessagesPerTask((int) value); return true;
            case "messageConverter": getOrCreateConfiguration((ActiveMQComponent) component).setMessageConverter((org.springframework.jms.support.converter.MessageConverter) value); return true;
            case "messageCreatedStrategy": getOrCreateConfiguration((ActiveMQComponent) component).setMessageCreatedStrategy((org.apache.camel.component.jms.MessageCreatedStrategy) value); return true;
            case "messageIdEnabled": getOrCreateConfiguration((ActiveMQComponent) component).setMessageIdEnabled((boolean) value); return true;
            case "messageListenerContainerFactory": getOrCreateConfiguration((ActiveMQComponent) component).setMessageListenerContainerFactory((org.apache.camel.component.jms.MessageListenerContainerFactory) value); return true;
            case "messageTimestampEnabled": getOrCreateConfiguration((ActiveMQComponent) component).setMessageTimestampEnabled((boolean) value); return true;
            case "pubSubNoLocal": getOrCreateConfiguration((ActiveMQComponent) component).setPubSubNoLocal((boolean) value); return true;
            case "queueBrowseStrategy": ((ActiveMQComponent) component).setQueueBrowseStrategy((org.apache.camel.component.jms.QueueBrowseStrategy) value); return true;
            case "receiveTimeout": getOrCreateConfiguration((ActiveMQComponent) component).setReceiveTimeout((long) value); return true;
            case "recoveryInterval": getOrCreateConfiguration((ActiveMQComponent) component).setRecoveryInterval((long) value); return true;
            case "requestTimeoutCheckerInterval": getOrCreateConfiguration((ActiveMQComponent) component).setRequestTimeoutCheckerInterval((long) value); return true;
            case "serviceLocationEnabled": ((ActiveMQComponent) component).setServiceLocationEnabled((boolean) value); return true;
            case "synchronous": getOrCreateConfiguration((ActiveMQComponent) component).setSynchronous((boolean) value); return true;
            case "temporaryQueueResolver": getOrCreateConfiguration((ActiveMQComponent) component).setTemporaryQueueResolver((org.apache.camel.component.jms.TemporaryQueueResolver) value); return true;
            case "transferException": getOrCreateConfiguration((ActiveMQComponent) component).setTransferException((boolean) value); return true;
            case "transferExchange": getOrCreateConfiguration((ActiveMQComponent) component).setTransferExchange((boolean) value); return true;
            case "trustAllPackages": ((ActiveMQComponent) component).setTrustAllPackages((boolean) value); return true;
            case "useMessageIDAsCorrelationID": getOrCreateConfiguration((ActiveMQComponent) component).setUseMessageIDAsCorrelationID((boolean) value); return true;
            case "waitForProvisionCorrelationToBeUpdatedCounter": getOrCreateConfiguration((ActiveMQComponent) component).setWaitForProvisionCorrelationToBeUpdatedCounter((int) value); return true;
            case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": getOrCreateConfiguration((ActiveMQComponent) component).setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime((long) value); return true;
            case "waitForTemporaryReplyToToBeUpdatedCounter": getOrCreateConfiguration((ActiveMQComponent) component).setWaitForTemporaryReplyToToBeUpdatedCounter((int) value); return true;
            case "waitForTemporaryReplyToToBeUpdatedThreadSleepingTime": getOrCreateConfiguration((ActiveMQComponent) component).setWaitForTemporaryReplyToToBeUpdatedThreadSleepingTime((long) value); return true;
            case "headerFilterStrategy": ((ActiveMQComponent) component).setHeaderFilterStrategy((org.apache.camel.spi.HeaderFilterStrategy) value); return true;
            case "errorHandlerLoggingLevel": getOrCreateConfiguration((ActiveMQComponent) component).setErrorHandlerLoggingLevel((org.apache.camel.LoggingLevel) value); return true;
            case "errorHandlerLogStackTrace": getOrCreateConfiguration((ActiveMQComponent) component).setErrorHandlerLogStackTrace((boolean) value); return true;
            case "password": getOrCreateConfiguration((ActiveMQComponent) component).setPassword((java.lang.String) value); return true;
            case "username": getOrCreateConfiguration((ActiveMQComponent) component).setUsername((java.lang.String) value); return true;
            case "transacted": getOrCreateConfiguration((ActiveMQComponent) component).setTransacted((boolean) value); return true;
            case "transactedInOut": getOrCreateConfiguration((ActiveMQComponent) component).setTransactedInOut((boolean) value); return true;
            case "lazyCreateTransactionManager": getOrCreateConfiguration((ActiveMQComponent) component).setLazyCreateTransactionManager((boolean) value); return true;
            case "transactionManager": getOrCreateConfiguration((ActiveMQComponent) component).setTransactionManager((org.springframework.transaction.PlatformTransactionManager) value); return true;
            case "transactionName": getOrCreateConfiguration((ActiveMQComponent) component).setTransactionName((java.lang.String) value); return true;
            case "transactionTimeout": getOrCreateConfiguration((ActiveMQComponent) component).setTransactionTimeout((int) value); return true;
            default: return false;
            }
        }
    }
}