/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.processing.Generated;

import org.apache.camel.component.fhir.api.FhirOperation;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;
import static org.apache.camel.support.component.ApiMethodArg.setter;

/**
 * Camel {@link ApiMethod} Enumeration for org.apache.camel.component.fhir.api.FhirOperation
 */
@Generated("org.apache.camel.maven.ApiComponentGeneratorMojo")
public enum FhirOperationApiMethod implements ApiMethod {

    ON_INSTANCE(
        org.hl7.fhir.instance.model.api.IBaseResource.class,
        "onInstance",
        arg("id", org.hl7.fhir.instance.model.api.IIdType.class),
        arg("name", String.class),
        arg("parameters", org.hl7.fhir.instance.model.api.IBaseParameters.class),
        arg("outputParameterType", Class.class),
        arg("useHttpGet", boolean.class),
        arg("returnType", Class.class),
        arg("extraParameters", java.util.Map.class)),

    ON_INSTANCE_VERSION(
        org.hl7.fhir.instance.model.api.IBaseResource.class,
        "onInstanceVersion",
        arg("id", org.hl7.fhir.instance.model.api.IIdType.class),
        arg("name", String.class),
        arg("parameters", org.hl7.fhir.instance.model.api.IBaseParameters.class),
        arg("outputParameterType", Class.class),
        arg("useHttpGet", boolean.class),
        arg("returnType", Class.class),
        arg("extraParameters", java.util.Map.class)),

    ON_SERVER(
        org.hl7.fhir.instance.model.api.IBaseResource.class,
        "onServer",
        arg("name", String.class),
        arg("parameters", org.hl7.fhir.instance.model.api.IBaseParameters.class),
        arg("outputParameterType", Class.class),
        arg("useHttpGet", boolean.class),
        arg("returnType", Class.class),
        arg("extraParameters", java.util.Map.class)),

    ON_TYPE(
        org.hl7.fhir.instance.model.api.IBaseResource.class,
        "onType",
        arg("resourceType", Class.class),
        arg("name", String.class),
        arg("parameters", org.hl7.fhir.instance.model.api.IBaseParameters.class),
        arg("outputParameterType", Class.class),
        arg("useHttpGet", boolean.class),
        arg("returnType", Class.class),
        arg("extraParameters", java.util.Map.class)),

    PROCESS_MESSAGE(
        org.hl7.fhir.instance.model.api.IBaseBundle.class,
        "processMessage",
        arg("respondToUri", String.class),
        arg("msgBundle", org.hl7.fhir.instance.model.api.IBaseBundle.class),
        arg("asynchronous", boolean.class),
        arg("responseClass", Class.class),
        arg("extraParameters", java.util.Map.class));

    private final ApiMethod apiMethod;

    FhirOperationApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(FhirOperation.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<String> getSetterArgNames() { return apiMethod.getSetterArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
