/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.hflame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.hflame.DefaultFrameColorChooser;
import org.gridkit.jvmtool.hflame.DefaultFrameFormater;
import org.gridkit.jvmtool.hflame.FrameColorChooser;
import org.gridkit.jvmtool.hflame.FrameFormater;
import org.gridkit.jvmtool.stacktrace.StackFrameList;

public class JsonFlameDataSet {
    private final Map<String, Integer> frameSet = new LinkedHashMap<String, Integer>();
    private final Map<String, ThreadDump> threads = new TreeMap<String, ThreadDump>();
    private final List<String> pallete = new ArrayList<String>();
    private FrameColorChooser colorer = new DefaultFrameColorChooser();
    private FrameFormater formater = new DefaultFrameFormater();

    public JsonFlameDataSet() {
        this.intern(Thread.State.RUNNABLE);
        this.intern(Thread.State.BLOCKED);
        this.intern(Thread.State.WAITING);
        this.intern(Thread.State.TIMED_WAITING);
    }

    private int intern(String frame) {
        if (this.frameSet.containsKey(frame)) {
            return this.frameSet.get(frame);
        }
        int n = this.frameSet.size();
        this.frameSet.put(frame, n);
        this.pallete.add(this.toColorLiteral(this.colorer.getFrameColor(frame)));
        return n;
    }

    private int intern(Thread.State state) {
        switch (state) {
            case BLOCKED: {
                return this.intern("(BLOCKED)");
            }
            case NEW: {
                return this.intern("(NEW)");
            }
            case RUNNABLE: {
                return this.intern("(RUNNABLE)");
            }
            case TERMINATED: {
                return this.intern("(TERMINATED)");
            }
            case TIMED_WAITING: {
                return this.intern("(TIMED_WAITING)");
            }
            case WAITING: {
                return this.intern("(WAITING)");
            }
        }
        return this.intern("(???)");
    }

    private String toColorLiteral(int color) {
        if (color < 0) {
            return "null";
        }
        String hex = Integer.toHexString(color + 0x1000000);
        hex = hex.substring(hex.length() - 6);
        return "\"#" + hex + "\"";
    }

    public void feed(Iterable<ThreadSnapshotEvent> events) {
        for (ThreadSnapshotEvent e : events) {
            if (e.stackTrace() == null || e.stackTrace().depth() <= 0) continue;
            String threadName = String.valueOf(e.threadName());
            ThreadDump dump = this.thread(threadName);
            int[] trace = this.intern(e);
            dump.count(trace);
        }
    }

    private int[] intern(ThreadSnapshotEvent e) {
        StackFrameList trace = e.stackTrace();
        int[] r = new int[trace.depth() + 1];
        for (int i = 0; i != trace.depth(); ++i) {
            int fp = trace.depth() - 1 - i;
            r[i] = this.intern(this.formater.toString(trace.frameAt(fp)));
        }
        r[r.length - 1] = e.threadState() == null ? this.intern("(???)") : this.intern(e.threadState());
        return r;
    }

    ThreadDump thread(String name) {
        ThreadDump dump = this.threads.get(name);
        if (dump == null) {
            dump = new ThreadDump(name);
            this.threads.put(name, dump);
        }
        return dump;
    }

    public void exportJson(StringBuilder sb) {
        sb.append("{");
        sb.append("frames: ");
        this.exportFrames(sb);
        sb.append(", ");
        sb.append("frameColors: ");
        this.exportFrameColors(sb);
        sb.append(", ");
        sb.append("threads: ");
        this.exportThreads(sb);
        sb.append("}");
    }

    private void exportFrames(StringBuilder sb) {
        sb.append("[");
        for (String frame : this.frameSet.keySet()) {
            sb.append('\"').append(frame).append("\", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
    }

    private void exportFrameColors(StringBuilder sb) {
        sb.append("[");
        for (String col : this.pallete) {
            sb.append(col).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
    }

    private void exportThreads(StringBuilder sb) {
        sb.append("[");
        for (ThreadDump td : this.threads.values()) {
            sb.append("{ name: \"").append(this.escape(td.threadName)).append("\", traces: [");
            for (TraceWeight tw : td.traces) {
                sb.append("{ trace: ").append(Arrays.toString(tw.trace)).append(", samples: ").append(tw.samples).append("}, ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]}, ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
    }

    private String escape(String threadName) {
        if (threadName.indexOf(92) >= 0) {
            threadName = threadName.replace("\\", "\\\\");
        }
        if (threadName.indexOf(34) >= 0) {
            threadName = threadName.replace("\"", "\\\"");
        }
        return threadName;
    }

    static class TraceWeight {
        public final int[] trace;
        public int samples;

        public TraceWeight(int[] trace, int samples) {
            this.trace = trace;
            this.samples = samples;
        }
    }

    static class ThreadDump {
        public final String threadName;
        public final List<TraceWeight> traces;

        public ThreadDump(String name) {
            this.threadName = name;
            this.traces = new ArrayList<TraceWeight>();
        }

        public void count(int[] trace) {
            for (TraceWeight t : this.traces) {
                if (!Arrays.equals(t.trace, trace)) continue;
                ++t.samples;
                return;
            }
            TraceWeight tw = new TraceWeight(trace, 1);
            this.traces.add(tw);
        }
    }
}

