/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.stacktrace.analytics.BasicFilterFactory;
import org.gridkit.jvmtool.stacktrace.analytics.ParserException;
import org.gridkit.jvmtool.stacktrace.analytics.PositionalStackMatcher;
import org.gridkit.jvmtool.stacktrace.analytics.StackFrameMatcher;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;

public class TraceFilterPredicateParser {
    private static final String REG_PAR = "[()]";
    private static final String REG_PATTERN = "[\\w\\d.:*$]+";
    private static final String REG_STATE_PATTERN = "#[Ss][Tt][Aa][Tt][Ee]=[\\w*]+";
    private static final String REG_COMMA = "[,]";
    private static final String REG_PLUS = "[+]";
    private static final String REG_EXCL = "[!]";
    private static final String REG_SLASH_PLUS = "[/][+]";
    private static final String REG_SLASH_EXCL = "[/][!]";
    private static final String REG_SLASH_UP_PLUS = "[/]\\^[+]";
    private static final String REG_SLASH_UP_EXCL = "[/]\\^[!]";
    static final Pattern TOKENIZER;

    public static ThreadSnapshotFilter parseFilter(String source, BasicFilterFactory factory) throws ParserException {
        FilterParser parser = new FilterParser(factory, source);
        return parser.parse();
    }

    public static PositionalStackMatcher parsePositionMatcher(String source, BasicFilterFactory factory) throws ParserException {
        FilterParser parser = new FilterParser(factory, source);
        return parser.parsePositionalMatcher();
    }

    static {
        String pattern = "(([()])|([\\w\\d.:*$]+)|([,])|([+])|([!])|([/][+])|([/][!])|([/]\\^[+])|([/]\\^[!])|(#[Ss][Tt][Aa][Tt][Ee]=[\\w*]+)|\\s+)";
        TOKENIZER = Pattern.compile(pattern);
    }

    private static class Op {
        TokenType toc;
        int rank;
        int offset;
        String body;
        Op left;
        Op right;

        private Op() {
        }

        public String toString() {
            if (this.left == null && this.right == null) {
                return "'" + this.body + "'";
            }
            return "'" + this.body + "'" + "(" + this.left + ", " + this.right + ")";
        }
    }

    private static enum TokenType {
        UNIVERSE,
        PATTERN,
        STATE_PATTERN,
        COMMA,
        PLUS,
        EXCL,
        SLASH_PLUS,
        SLASH_EXCL,
        SLASH_UP_PLUS,
        SLASH_UP_EXCL;

    }

    private static class FilterParser {
        List<List<Op>> stackStash = new ArrayList<List<Op>>();
        List<Op> stack = new ArrayList<Op>();
        String text;
        Matcher matcher;
        int offset;
        BasicFilterFactory filterFactory;

        public FilterParser(BasicFilterFactory factory, String text) {
            this.text = text;
            this.filterFactory = factory;
            this.matcher = TOKENIZER.matcher(text);
        }

        public ThreadSnapshotFilter parse() {
            this.parseText();
            Op root = this.collapse();
            return this.produceFilter(root);
        }

        public PositionalStackMatcher parsePositionalMatcher() {
            this.parseText();
            Op root = this.collapse();
            return this.producePosFilter(root);
        }

        protected void parseText() {
            while (true) {
                if (this.matcher.lookingAt()) {
                    this.offset = this.matcher.start();
                    if (this.matcher.group(2) != null) {
                        this.processPar();
                    } else if (this.matcher.group(3) != null) {
                        this.processPattern();
                    } else if (this.matcher.group(4) != null) {
                        this.processOp(TokenType.COMMA, 3);
                    } else if (this.matcher.group(5) != null) {
                        this.processOp(TokenType.PLUS, 1);
                    } else if (this.matcher.group(6) != null) {
                        this.processOp(TokenType.EXCL, 1);
                    } else if (this.matcher.group(7) != null) {
                        this.processOp(TokenType.SLASH_PLUS, 2);
                    } else if (this.matcher.group(8) != null) {
                        this.processOp(TokenType.SLASH_EXCL, 2);
                    } else if (this.matcher.group(9) != null) {
                        this.processOp(TokenType.SLASH_UP_PLUS, 2);
                    } else if (this.matcher.group(10) != null) {
                        this.processOp(TokenType.SLASH_UP_EXCL, 2);
                    } else if (this.matcher.group(11) != null) {
                        this.processStatePattern();
                    }
                } else {
                    throw this.error(this.matcher.regionStart(), "cannot parse");
                }
                if (this.matcher.end() == this.text.length()) break;
                this.matcher.region(this.matcher.end(), this.text.length());
            }
        }

        private void processOp(TokenType tt, int rank) {
            Op op = new Op();
            op.toc = tt;
            op.rank = rank;
            op.body = this.matcher.group(1);
            op.offset = this.matcher.start();
            this.pushToken(op);
        }

        private void processPattern() {
            String pattern = this.matcher.group(1);
            Op op = new Op();
            op.toc = TokenType.PATTERN;
            op.rank = -1;
            op.body = pattern;
            op.offset = this.matcher.start();
            this.pushToken(op);
        }

        private void processUniverse() {
            String pattern = this.matcher.group(1);
            Op op = new Op();
            op.toc = TokenType.UNIVERSE;
            op.rank = -1;
            op.body = pattern;
            op.offset = this.matcher.start();
            this.pushToken(op);
        }

        private void processStatePattern() {
            String pattern = this.matcher.group(1);
            int off = "#STATE=".length();
            Op op = new Op();
            op.toc = TokenType.STATE_PATTERN;
            op.rank = -1;
            op.body = pattern.substring(off);
            op.offset = this.matcher.start() + off;
            this.pushToken(op);
        }

        private void processPar() {
            if (this.text.charAt(this.matcher.start()) == '(') {
                this.stashStack();
            } else {
                if (this.stackStash.isEmpty()) {
                    this.error(this.offset, "No mathcing paranthesis");
                }
                Op op = this.collapse();
                op.rank = -1;
                this.unstashStack();
                this.pushToken(op);
            }
        }

        private Op collapse() {
            if (this.stack.isEmpty()) {
                this.error(this.offset, "Empty expression");
            }
            if (this.stack.get((int)(this.stack.size() - 1)).rank > 0) {
                this.error(this.offset, "Incomplete operator");
            }
            while (this.stack.size() > 1) {
                this.mergeLastOp();
            }
            return this.stack.get(0);
        }

        private void unstashStack() {
            if (this.stackStash.size() < 0) {
                throw new RuntimeException("Nothing on stack");
            }
            this.stack = this.stackStash.remove(this.stackStash.size() - 1);
        }

        private void stashStack() {
            this.stackStash.add(this.stack);
            this.stack = new ArrayList<Op>();
        }

        private Op last() {
            return this.stack.get(this.stack.size() - 1);
        }

        private void pushToken(Op op) {
            if (op.rank < 0) {
                if (this.stack.isEmpty()) {
                    this.stack.add(op);
                } else if (this.last().rank < 0) {
                    this.error(op.offset, " operator expected");
                } else {
                    this.stack.add(op);
                }
            } else if (op.rank >= 0) {
                if (this.stack.isEmpty()) {
                    if (op.toc == TokenType.EXCL) {
                        this.processUniverse();
                    } else {
                        this.error(op.offset, " operator expected");
                    }
                }
                while (true) {
                    int lor;
                    if ((lor = this.lastOpRank()) < 0 || lor < op.rank) {
                        this.stack.add(op);
                        break;
                    }
                    this.mergeLastOp();
                }
            }
        }

        private int lastOpRank() {
            if (this.stack.size() == 0) {
                return -1;
            }
            int s2 = this.stack.size();
            Op op = this.stack.get(s2 - 1);
            if (op.rank >= 0) {
                return op.rank;
            }
            if (this.stack.size() < 2) {
                return -1;
            }
            return this.stack.get((int)(s2 - 2)).rank;
        }

        private void mergeLastOp() {
            int s2 = this.stack.size();
            Op b = this.stack.remove(s2 - 1);
            Op o = this.stack.remove(s2 - 2);
            Op a = this.stack.remove(s2 - 3);
            if (o.rank < 0) {
                throw new RuntimeException("Op already collapsed");
            }
            o.left = a;
            o.right = b;
            o.rank = -1;
            this.stack.add(o);
        }

        private RuntimeException error(int offs, String message) {
            throw new ParserException(this.text, offs, message);
        }

        private ThreadSnapshotFilter produceFilter(Op node) {
            switch (node.toc) {
                case PATTERN: {
                    return this.filterFactory.frameFilter(this.filterFactory.patternFrameMatcher(this.refinePattern(node.body)));
                }
                case STATE_PATTERN: {
                    return this.filterFactory.threadStateMatter(node.body);
                }
                case COMMA: {
                    return this.produceConjunctionFilter(node);
                }
                case PLUS: {
                    return this.filterFactory.disjunction(this.produceFilter(node.left), this.produceFilter(node.right));
                }
                case EXCL: {
                    return this.filterFactory.disjunction(this.produceFilter(node.left), this.filterFactory.not(this.produceFilter(node.right)));
                }
                case SLASH_PLUS: {
                    return this.filterFactory.followed(this.filterFactory.lastFrame(this.produceMatcher(node.left)), this.produceFilter(node.right));
                }
                case SLASH_EXCL: {
                    return this.filterFactory.followed(this.filterFactory.lastFrame(this.produceMatcher(node.left)), this.filterFactory.not(this.produceFilter(node.right)));
                }
                case SLASH_UP_PLUS: {
                    return this.filterFactory.followed(this.filterFactory.firstFrame(this.produceMatcher(node.left)), this.produceFilter(node.right));
                }
                case SLASH_UP_EXCL: {
                    return this.filterFactory.followed(this.filterFactory.firstFrame(this.produceMatcher(node.left)), this.filterFactory.not(this.produceFilter(node.right)));
                }
                case UNIVERSE: {
                    return this.filterFactory.trueFilter();
                }
            }
            throw new RuntimeException("Unknown node");
        }

        private PositionalStackMatcher producePosFilter(Op node) {
            switch (node.toc) {
                case PATTERN: 
                case COMMA: {
                    return (PositionalStackMatcher)((Object)this.filterFactory.followed(this.filterFactory.firstFrame(this.produceMatcher(node)), this.filterFactory.trueFilter()));
                }
                case SLASH_PLUS: {
                    return (PositionalStackMatcher)((Object)this.filterFactory.followed(this.filterFactory.lastFrame(this.produceMatcher(node.left)), this.produceFilter(node.right)));
                }
                case SLASH_EXCL: {
                    return (PositionalStackMatcher)((Object)this.filterFactory.followed(this.filterFactory.lastFrame(this.produceMatcher(node.left)), this.filterFactory.not(this.produceFilter(node.right))));
                }
                case SLASH_UP_PLUS: {
                    return (PositionalStackMatcher)((Object)this.filterFactory.followed(this.filterFactory.firstFrame(this.produceMatcher(node.left)), this.produceFilter(node.right)));
                }
                case SLASH_UP_EXCL: {
                    return (PositionalStackMatcher)((Object)this.filterFactory.followed(this.filterFactory.firstFrame(this.produceMatcher(node.left)), this.filterFactory.not(this.produceFilter(node.right))));
                }
            }
            throw new RuntimeException("Positional operator required");
        }

        private ThreadSnapshotFilter produceConjunctionFilter(Op node) {
            ArrayList<String> pattern = new ArrayList<String>();
            while (node.toc == TokenType.COMMA && node.right.toc == TokenType.PATTERN) {
                pattern.add(this.refinePattern(node.right.body));
                node = node.left;
            }
            if (pattern.isEmpty()) {
                return this.filterFactory.conjunction(this.produceFilter(node.left), this.produceFilter(node.right));
            }
            if (node.toc == TokenType.PATTERN) {
                pattern.add(this.refinePattern(node.body));
                node = null;
            }
            ThreadSnapshotFilter f = this.filterFactory.frameFilter(this.filterFactory.patternFrameMatcher(pattern));
            return node == null ? f : this.filterFactory.conjunction(f, this.produceFilter(node));
        }

        private StackFrameMatcher produceConjunctionMatcher(Op node) {
            ArrayList<String> pattern = new ArrayList<String>();
            while (node.toc == TokenType.COMMA && node.right.toc == TokenType.PATTERN) {
                pattern.add(this.refinePattern(node.right.body));
                node = node.left;
            }
            if (pattern.isEmpty()) {
                return this.filterFactory.matcherConjunction(this.produceMatcher(node), this.produceMatcher(node.right));
            }
            if (node.toc == TokenType.PATTERN) {
                pattern.add(this.refinePattern(node.body));
                node = null;
            }
            StackFrameMatcher f = this.filterFactory.patternFrameMatcher(pattern);
            return node == null ? f : this.filterFactory.matcherConjunction(f, this.produceMatcher(node));
        }

        private String refinePattern(String body) {
            int c = body.lastIndexOf(58);
            if (c > 0) {
                if (c > 2 && body.charAt(c - 1) == '*' && body.charAt(c - 2) == '*') {
                    return body;
                }
                if (c > 1 && body.charAt(c - 1) == '*') {
                    return body.substring(0, c - 1) + "*.*:" + body.substring(c + 1);
                }
            }
            return body;
        }

        private StackFrameMatcher produceMatcher(Op node) {
            switch (node.toc) {
                case PATTERN: {
                    return this.filterFactory.patternFrameMatcher(this.refinePattern(node.body));
                }
                case STATE_PATTERN: {
                    throw this.error(node.offset, "Unsupported for frame predicate");
                }
                case COMMA: {
                    return this.produceConjunctionMatcher(node);
                }
                case PLUS: {
                    throw this.error(node.offset, "Unsupported for frame predicate");
                }
                case EXCL: {
                    throw this.error(node.offset, "Unsupported for frame predicate");
                }
                case SLASH_PLUS: {
                    throw this.error(node.offset, "Unsupported for frame predicate");
                }
                case SLASH_EXCL: {
                    throw this.error(node.offset, "Unsupported for frame predicate");
                }
                case SLASH_UP_PLUS: {
                    throw this.error(node.offset, "Unsupported for frame predicate");
                }
                case SLASH_UP_EXCL: {
                    throw this.error(node.offset, "Unsupported for frame predicate");
                }
                case UNIVERSE: {
                    return this.filterFactory.patternFrameMatcher("**");
                }
            }
            throw new RuntimeException("Unknown node");
        }
    }
}

