/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics.flame;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gridkit.jvmtool.stacktrace.GenericStackElement;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.analytics.flame.DefaultColorPicker;
import org.gridkit.jvmtool.stacktrace.analytics.flame.FlameColorPicker;

public abstract class AbstractFlameCharter {
    private static final GenericStackElement[] ROOT = new GenericStackElement[0];
    private static final Locale SVG_LOCALE = Locale.ROOT;
    private Node root;
    private FlameColorPicker colorPicker = new DefaultColorPicker();

    public AbstractFlameCharter() {
        this.root = new Node(ROOT, this.comparator());
    }

    protected abstract Comparator<GenericStackElement> comparator();

    public void setColorPicker(FlameColorPicker cp) {
        this.colorPicker = cp;
    }

    public void feed(StackFrameList trace) {
        Node node = this.root;
        ++node.totalCount;
        for (int i = trace.depth(); i > 0; --i) {
            StackFrame f = trace.frameAt(i - 1).withoutSource();
            Node c = node.child(f);
            ++c.totalCount;
            node = c;
        }
        ++node.terminalCount;
    }

    public void renderSVG(String title, int width, Writer writer) throws IOException {
        int topm = 24;
        int bm = 0;
        int frameheight = 16;
        int threashold = (int)(1.5 * (double)this.root.totalCount / (double)width);
        int maxDepth = this.calculateMaxDepth(this.root, threashold);
        int height = maxDepth * frameheight + topm + bm;
        this.appendHeader(width, height, writer);
        this.format(writer, "<rect x=\"0.0\" y=\"0\" width=\"%d\" height=\"%d\" fill=\"url(#background)\"/>\n", width, height);
        this.format(writer, "<text text-anchor=\"middle\" x=\"%d\" y=\"%d\" font-size=\"17\" font-family=\"Verdana\" fill=\"rgb(0,0,0)\"  >%s</text>\n", width / 2, topm, title);
        this.appendChildNodes(writer, this.root, 0, width, height - frameheight, frameheight, threashold);
        this.format(writer, "</svg>", new Object[0]);
    }

    private int calculateMaxDepth(Node node, int threshold) {
        if (node.totalCount < threshold) {
            return 0;
        }
        int max = 0;
        for (Node n : node.children.values()) {
            max = Math.max(max, this.calculateMaxDepth(n, threshold));
        }
        return max + 1;
    }

    private void appendChildNodes(Writer writer, Node node, int xoffs, int width, int height, int frameheight, int threshold) throws IOException {
        int x = xoffs;
        for (Node child : node.children.values()) {
            if (child.totalCount > threshold) {
                this.renderNode(writer, child, x, height, width, frameheight);
                this.appendChildNodes(writer, child, x, width, height - frameheight, frameheight, threshold);
            }
            x += child.totalCount;
        }
        if (node.terminalCount > threshold) {
            this.renderSmoke(writer, x, node.terminalCount, height, width, frameheight);
        }
    }

    private void renderNode(Writer writer, Node node, int x, int height, int width, int frameheight) throws IOException {
        double rx = (double)width * (double)x / (double)this.root.totalCount;
        double rw = (double)width * (double)node.totalCount / (double)this.root.totalCount;
        double ry = height;
        double rh = frameheight;
        int c = this.colorPicker.pickColor(node.path);
        int cr = 0xFF & c >> 16;
        int cg = 0xFF & c >> 8;
        int cb = 0xFF & c >> 0;
        this.format(writer, "<g class=\"fbar\">\n", new Object[0]);
        this.format(writer, "<title>%s (%d samples, %.2f%%)</title>\n", this.escape(this.describe(node)), node.totalCount, 100.0 * (double)node.totalCount / (double)this.root.totalCount);
        this.format(writer, "<rect x=\"%.1f\" y=\"%.1f\" width=\"%.1f\" height=\"%.1f\" fill=\"rgb(%d,%d,%d)\" rx=\"2\" ry=\"2\"/>\n", rx, ry, rw, rh, cr, cg, cb);
        this.format(writer, "<text x=\"%.1f\" y=\"%.1f\" fill=\"rgb(0,0,0)\">%s</text>\n", rx + 10.0, ry + (double)frameheight - 3.0, this.escape(this.trimStr(this.describe(node), (int)(rw - 10.0) / 7)));
        this.format(writer, "</g>\n", new Object[0]);
    }

    private void renderSmoke(Writer writer, int x, int samples, int height, int width, int frameheight) throws IOException {
        double rx = (double)width * (double)x / (double)this.root.totalCount;
        double rw = (double)width * (double)samples / (double)this.root.totalCount;
        double ry = height;
        double rh = frameheight;
        this.format(writer, "<g>\n", new Object[0]);
        this.format(writer, "<title>%d samples, %.2f%%</title>", samples, 100.0 * (double)samples / (double)this.root.totalCount);
        this.format(writer, "<rect x=\"%.1f\" y=\"%.1f\" width=\"%.1f\" height=\"%.1f\" fill=\"rgb(20,20,20)\" rx=\"1\" ry=\"1\"/>\n", rx, ry + rh / 2.0, rw, Float.valueOf(3.0f));
        this.format(writer, "</g>\n", new Object[0]);
    }

    private String trimStr(String describe, int len) {
        if (len < 3) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int n = Math.min(describe.length(), len);
        boolean trimed = describe.length() > len;
        for (int i = 0; i != n; ++i) {
            if (trimed && i > n - 3) {
                sb.append('.');
                continue;
            }
            sb.append(describe.charAt(i));
        }
        return sb.toString();
    }

    protected String escape(String text) {
        return text.replace("<", "&lt;").replace(">", "&gt;");
    }

    protected abstract String describe(Node var1);

    private void format(Writer writer, String format, Object ... args) throws IOException {
        writer.append(String.format(SVG_LOCALE, format, args));
    }

    protected void appendHeader(int width, int height, Writer writer) throws IOException {
        this.format(writer, "<?xml version=\"1.0\" standalone=\"no\"?>\n", new Object[0]);
        this.format(writer, "<svg version=\"1.1\" width=\"%d\" height=\"%d\" onload=\"init(evt)\" viewBox=\"0 0 %d %d\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n", width, height, width, height);
        this.format(writer, "<defs>", new Object[0]);
        this.format(writer, "  <linearGradient id=\"background\" y1=\"0\" y2=\"1\" x1=\"0\" x2=\"0\">\n", new Object[0]);
        this.format(writer, "      <stop stop-color=\"#eeeeee\" offset=\"5%%\"/>\n", new Object[0]);
        this.format(writer, "      <stop stop-color=\"#eeeeb0\" offset=\"95%%\"/>\n", new Object[0]);
        this.format(writer, "  </linearGradient>\n", new Object[0]);
        this.format(writer, "</defs>\n", new Object[0]);
        this.format(writer, "<style type=\"text/css\">\n", new Object[0]);
        this.format(writer, "  text { font-size:12px; font-family:Verdana }\n", new Object[0]);
        this.format(writer, "  .fbar:hover { stroke:black; stroke-width:0.5; cursor:pointer; }\n", new Object[0]);
        this.format(writer, "</style>\n", new Object[0]);
    }

    static class Node {
        GenericStackElement[] path;
        int totalCount;
        int terminalCount;
        Comparator<GenericStackElement> comparator;
        SortedMap<GenericStackElement, Node> children;

        public Node(GenericStackElement[] path, Comparator<GenericStackElement> comparator) {
            this.path = path;
            this.comparator = comparator;
            this.children = new TreeMap<GenericStackElement, Node>(comparator);
        }

        public Node child(GenericStackElement f) {
            Node c = (Node)this.children.get(f);
            if (c == null) {
                GenericStackElement[] npath = Arrays.copyOf(this.path, this.path.length + 1);
                npath[this.path.length] = f;
                c = new Node(npath, this.comparator);
                this.children.put(f, c);
            }
            return c;
        }

        public GenericStackElement element() {
            return this.path[this.path.length - 1];
        }

        public String toString() {
            return this.path.length == 0 ? "<root>" : this.path[this.path.length - 1].toString();
        }
    }
}

