/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.testing.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WithProperties
implements AutoCloseable {
    private final List<Runnable> rollback = new ArrayList<Runnable>();

    public WithProperties with(String ... kvs) {
        assert (kvs.length % 2 == 0) : "Input must have an even amount of inputs but given " + kvs.length;
        for (int i = 0; i <= kvs.length - 2; i += 2) {
            this.with(kvs[i], kvs[i + 1]);
        }
        return this;
    }

    private void with(String key, String value) {
        String previous = System.setProperty(key, value);
        this.rollback.add(previous == null ? () -> System.clearProperty(key) : () -> System.setProperty(key, previous));
    }

    @Override
    public void close() {
        Collections.reverse(this.rollback);
        this.rollback.forEach(Runnable::run);
        this.rollback.clear();
    }
}

