/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.exception;

import java.time.Instant;
import org.apache.cassandra.spark.exception.AnalyticsException;

public class TimeSkewTooLargeException
extends AnalyticsException {
    private static final long serialVersionUID = -6748770894292325624L;

    public TimeSkewTooLargeException(int allowableDurationMinutes, Instant localNow, Instant remoteNow, String clusterId) {
        super(TimeSkewTooLargeException.makeExceptionMessage("Time skew between Spark and Cassandra is too large", allowableDurationMinutes, localNow, remoteNow, clusterId));
    }

    private static String makeExceptionMessage(String summary, int allowableDurationMinutes, Instant localNow, Instant remoteNow, String clusterId) {
        return String.format("%s. allowableSkewInMinutes=%d, localTime=%s, remoteCassandraTime=%s, clusterId=%s", summary, allowableDurationMinutes, localNow, remoteNow, clusterId);
    }
}

