/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.PowerIterator;
import ch.obermuhlner.math.big.internal.PowerTwoNPlusOneIterator;
import ch.obermuhlner.math.big.internal.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class SinCalculator
extends SeriesCalculator {
    public static final SinCalculator INSTANCE = new SinCalculator();
    private int n = 0;
    private boolean negative = false;
    private BigRational factorial2nPlus1 = BigRational.ONE;

    private SinCalculator() {
        super(true);
    }

    @Override
    protected BigRational getCurrentFactor() {
        BigRational factor = this.factorial2nPlus1.reciprocal();
        if (this.negative) {
            factor = factor.negate();
        }
        return factor;
    }

    @Override
    protected void calculateNextFactor() {
        ++this.n;
        this.factorial2nPlus1 = this.factorial2nPlus1.multiply(2 * this.n);
        this.factorial2nPlus1 = this.factorial2nPlus1.multiply(2 * this.n + 1);
        this.negative = !this.negative;
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal x, MathContext mathContext) {
        return new PowerTwoNPlusOneIterator(x, mathContext);
    }
}

