/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.IOException;
import org.apache.cassandra.index.sai.disk.format.Version;
import org.apache.cassandra.index.sai.disk.io.IndexFileUtils;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class SAICodecUtils {
    public static final String FOOTER_POINTER = "footerPointer";

    public static void writeHeader(IndexOutput out) throws IOException {
        CodecUtil.writeBEInt(out, 1071082519);
        out.writeString(Version.LATEST.toString());
    }

    public static void writeFooter(IndexOutput out) throws IOException {
        CodecUtil.writeBEInt(out, -1071082520);
        CodecUtil.writeBEInt(out, 0);
        SAICodecUtils.writeChecksum(out);
    }

    public static void checkHeader(DataInput in) throws IOException {
        int actualMagic = CodecUtil.readBEInt(in);
        if (actualMagic != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + actualMagic + " vs expected header=1071082519", in);
        }
        Version actualVersion = Version.parse(in.readString());
        if (!actualVersion.onOrAfter(Version.EARLIEST)) {
            throw new IOException("Unsupported version: " + actualVersion);
        }
    }

    public static void checkFooter(ChecksumIndexInput in) throws IOException {
        SAICodecUtils.validateFooter(in, false);
        long actualChecksum = in.getChecksum();
        long expectedChecksum = SAICodecUtils.readChecksum(in);
        if (expectedChecksum != actualChecksum) {
            throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + Long.toHexString(expectedChecksum) + " actual=" + Long.toHexString(actualChecksum), in);
        }
    }

    public static void validate(IndexInput input) throws IOException {
        SAICodecUtils.checkHeader(input);
        SAICodecUtils.validateFooterAndResetPosition(input);
    }

    public static void validate(IndexInput input, long footerPointer) throws IOException {
        SAICodecUtils.checkHeader(input);
        long current = input.getFilePointer();
        input.seek(footerPointer);
        SAICodecUtils.validateFooter(input, true);
        input.seek(current);
    }

    public static void validateChecksum(IndexInput input) throws IOException {
        IndexInput clone = input.clone();
        clone.seek(0L);
        ChecksumIndexInput in = IndexFileUtils.getBufferedChecksumIndexInput(clone);
        assert (in.getFilePointer() == 0L) : in.getFilePointer() + " bytes already read from this input!";
        if (in.length() < (long)CodecUtil.footerLength()) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): length=" + in.length() + " but footerLength==" + CodecUtil.footerLength(), input);
        }
        in.seek(in.length() - (long)CodecUtil.footerLength());
        SAICodecUtils.checkFooter(in);
    }

    public static int checkBlockSize(int blockSize, int minBlockSize, int maxBlockSize) {
        if (blockSize >= minBlockSize && blockSize <= maxBlockSize) {
            if ((blockSize & blockSize - 1) != 0) {
                throw new IllegalArgumentException("blockSize must be a power of two, got " + blockSize);
            }
            return Integer.numberOfTrailingZeros(blockSize);
        }
        throw new IllegalArgumentException("blockSize must be >= " + minBlockSize + " and <= " + maxBlockSize + ", got " + blockSize);
    }

    public static int numBlocks(long size, int blockSize) {
        if (size < 0L) {
            throw new IllegalArgumentException("size cannot be negative");
        }
        int numBlocks = (int)(size / (long)blockSize) + (size % (long)blockSize == 0L ? 0 : 1);
        if ((long)numBlocks * (long)blockSize < size) {
            throw new IllegalArgumentException("size is too large for this block size");
        }
        return numBlocks;
    }

    public static long readVLong(DataInput in) throws IOException {
        byte b = in.readByte();
        if (b >= 0) {
            return b;
        }
        long i = (long)b & 0x7FL;
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        return i |= ((long)b & 0xFFL) << 56;
    }

    public static void validateFooterAndResetPosition(IndexInput in) throws IOException {
        long footerLength;
        long position = in.getFilePointer();
        long fileLength = in.length();
        long footerPosition = fileLength - (footerLength = (long)CodecUtil.footerLength());
        if (footerPosition < 0L) {
            throw new CorruptIndexException("invalid codec footer (file truncated?): file length=" + fileLength + ", footer length=" + footerLength, in);
        }
        in.seek(footerPosition);
        SAICodecUtils.validateFooter(in, false);
        in.seek(position);
    }

    private static void validateFooter(IndexInput in, boolean segmented) throws IOException {
        int magic;
        long remaining = in.length() - in.getFilePointer();
        long expected = CodecUtil.footerLength();
        if (!segmented) {
            if (remaining < expected) {
                throw new CorruptIndexException("misplaced codec footer (file truncated?): remaining=" + remaining + ", expected=" + expected + ", fp=" + in.getFilePointer(), in);
            }
            if (remaining > expected) {
                throw new CorruptIndexException("misplaced codec footer (file extended?): remaining=" + remaining + ", expected=" + expected + ", fp=" + in.getFilePointer(), in);
            }
        }
        if ((magic = CodecUtil.readBEInt(in)) != -1071082520) {
            throw new CorruptIndexException("codec footer mismatch (file truncated?): actual footer=" + magic + " vs expected footer=-1071082520", in);
        }
        int algorithmID = CodecUtil.readBEInt(in);
        if (algorithmID != 0) {
            throw new CorruptIndexException("codec footer mismatch: unknown algorithmID: " + algorithmID, in);
        }
    }

    private static void writeChecksum(IndexOutput output) throws IOException {
        long value = output.getChecksum();
        if ((value & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("Illegal checksum: " + value + " (resource=" + output + ")");
        }
        CodecUtil.writeBELong(output, value);
    }

    private static long readChecksum(IndexInput input) throws IOException {
        long value = CodecUtil.readBELong(input);
        if ((value & 0xFFFFFFFF00000000L) != 0L) {
            throw new CorruptIndexException("Illegal checksum: " + value, input);
        }
        return value;
    }
}

