/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.utils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class AtomicRatio {
    private final AtomicReference<Ratio> ratio = new AtomicReference<Ratio>(new Ratio(0L, 0L));
    private final AtomicInteger updateCount = new AtomicInteger();

    public void update(long numerator, long denominator) {
        this.ratio.updateAndGet(current -> new Ratio(current.numerator + numerator, current.denominator + denominator));
        this.updateCount.incrementAndGet();
    }

    public double get() {
        Ratio current = this.ratio.get();
        return (double)current.numerator / (double)current.denominator;
    }

    public int getUpdateCount() {
        return this.updateCount.get();
    }

    private static class Ratio {
        public final long numerator;
        public final long denominator;

        public Ratio(long numerator, long denominator) {
            this.numerator = numerator;
            this.denominator = denominator;
        }
    }
}

