/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.IOException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.AbstractSSTableIterator;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.bti.BtiTableReader;
import org.apache.cassandra.io.sstable.format.bti.RowIndexReader;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;

class SSTableIterator
extends AbstractSSTableIterator<AbstractRowIndexEntry> {
    private int slice;

    public SSTableIterator(BtiTableReader sstable, FileDataInput file, DecoratedKey key, AbstractRowIndexEntry indexEntry, Slices slices, ColumnFilter columns, FileHandle ifile) {
        super(sstable, file, key, indexEntry, slices, columns, ifile);
    }

    @Override
    protected AbstractSSTableIterator.Reader createReaderInternal(AbstractRowIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile, Version version) {
        if (indexEntry.isIndexed()) {
            return new ForwardIndexedReader(indexEntry, file, shouldCloseFile, version);
        }
        return new AbstractSSTableIterator.ForwardReader(file, shouldCloseFile);
    }

    @Override
    protected int nextSliceIndex() {
        int next = this.slice++;
        return next;
    }

    @Override
    protected boolean hasMoreSlices() {
        return this.slice < this.slices.size();
    }

    @Override
    public boolean isReverseOrder() {
        return false;
    }

    private class ForwardIndexedReader
    extends AbstractSSTableIterator.ForwardReader {
        private final RowIndexReader indexReader;
        private final long basePosition;
        private final Version version;

        private ForwardIndexedReader(AbstractRowIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile, Version version) {
            super(file, shouldCloseFile);
            this.basePosition = indexEntry.position;
            this.version = version;
            this.indexReader = new RowIndexReader(SSTableIterator.this.ifile, (TrieIndexEntry)indexEntry, version);
        }

        @Override
        public void close() throws IOException {
            this.indexReader.close();
            super.close();
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            super.setForSlice(slice);
            RowIndexReader.IndexInfo indexInfo = this.indexReader.separatorFloor(((SSTableIterator)SSTableIterator.this).metadata.comparator.asByteComparable(slice.start()));
            assert (indexInfo != null);
            long position = this.basePosition + indexInfo.offset;
            if (this.file == null || position > this.file.getFilePointer()) {
                this.openMarker = indexInfo.openDeletion;
                this.seekToPosition(position);
            }
        }
    }
}

