/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.tries;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.tries.IncrementalDeepTrieWriterPageAware;
import org.apache.cassandra.io.tries.TrieSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

public interface IncrementalTrieWriter<VALUE>
extends AutoCloseable {
    public void add(ByteComparable var1, VALUE var2) throws IOException;

    public long count();

    public long complete() throws IOException;

    public void reset();

    @Override
    public void close();

    public PartialTail makePartialRoot() throws IOException;

    public static <VALUE> IncrementalTrieWriter<VALUE> open(TrieSerializer<VALUE, ? super DataOutputPlus> trieSerializer, DataOutputPlus dest) {
        return new IncrementalDeepTrieWriterPageAware<VALUE>(trieSerializer, dest);
    }

    public static interface PartialTail {
        public long root();

        public long count();

        public long cutoff();

        public ByteBuffer tail();
    }
}

