/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.AsyncFuture;
import org.apache.cassandra.utils.concurrent.Future;

public interface Scheduler {
    default public <T> Future<T> schedule(Supplier<Future<T>> task, Executor executor) {
        return this.schedule(new Task<T>(task), executor);
    }

    public <T> Task<T> schedule(Task<T> var1, Executor var2);

    public static Scheduler build(int concurrentValidations) {
        return concurrentValidations <= 0 ? new NoopScheduler() : new LimitedConcurrentScheduler(concurrentValidations);
    }

    public static class Task<T>
    extends AsyncFuture<T>
    implements Runnable {
        private final Supplier<Future<T>> supplier;

        public Task(Supplier<Future<T>> supplier) {
            this.supplier = supplier;
        }

        @Override
        public void run() {
            this.supplier.get().addCallback((? super V s2, Throwable f) -> {
                if (f != null) {
                    this.tryFailure((Throwable)f);
                } else {
                    this.trySuccess(s2);
                }
            });
        }
    }

    public static final class LimitedConcurrentScheduler
    implements Scheduler {
        private final int concurrentValidations;
        @GuardedBy(value="this")
        private int inflight = 0;
        @GuardedBy(value="this")
        private final Queue<Pair<Task<?>, Executor>> tasks = new LinkedList();

        LimitedConcurrentScheduler(int concurrentValidations) {
            this.concurrentValidations = concurrentValidations;
        }

        @Override
        public synchronized <T> Task<T> schedule(Task<T> task, Executor executor) {
            this.tasks.offer(Pair.create(task, executor));
            this.maybeSchedule();
            return task;
        }

        private synchronized void onDone() {
            --this.inflight;
            this.maybeSchedule();
        }

        private void maybeSchedule() {
            if (this.inflight == this.concurrentValidations || this.tasks.isEmpty()) {
                return;
            }
            ++this.inflight;
            Pair<Task<?>, Executor> pair = this.tasks.poll();
            ((Task)pair.left).addCallback((s2, f) -> this.onDone());
            ((Executor)pair.right).execute((Runnable)pair.left);
        }
    }

    public static final class NoopScheduler
    implements Scheduler {
        @Override
        public <T> Task<T> schedule(Task<T> task, Executor executor) {
            executor.execute(task);
            return task;
        }
    }
}

