/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.uncommitted;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.cleanup.PaxosRepairState;
import org.apache.cassandra.service.paxos.uncommitted.PaxosKeyState;
import org.apache.cassandra.service.paxos.uncommitted.UncommittedPaxosKey;
import org.apache.cassandra.service.paxos.uncommitted.UncommittedTableData;
import org.apache.cassandra.utils.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosUncommittedTracker {
    private static final Logger logger = LoggerFactory.getLogger(PaxosUncommittedTracker.class);
    private static final Range<Token> FULL_RANGE = new Range<Token>(DatabaseDescriptor.getPartitioner().getMinimumToken(), DatabaseDescriptor.getPartitioner().getMinimumToken());
    private static volatile UpdateSupplier updateSupplier;
    private volatile boolean autoRepairsEnabled = !CassandraRelevantProperties.DISABLE_PAXOS_AUTO_REPAIRS.getBoolean();
    private volatile boolean stateFlushEnabled = !CassandraRelevantProperties.DISABLE_PAXOS_STATE_FLUSH.getBoolean();
    private boolean started = false;
    private boolean autoRepairStarted = false;
    private final Set<TableId> autoRepairTableIds = Sets.newConcurrentHashSet();
    private final File dataDirectory;
    private volatile ImmutableMap<TableId, UncommittedTableData> tableStates;

    public PaxosUncommittedTracker(File dataDirectory, ImmutableMap<TableId, UncommittedTableData> tableStates) {
        this.dataDirectory = dataDirectory;
        this.tableStates = tableStates;
    }

    public PaxosUncommittedTracker(File dataDirectory) {
        this(dataDirectory, ImmutableMap.of());
    }

    public File getDirectory() {
        return this.dataDirectory;
    }

    public static void truncate(File dataDirectory) {
        logger.info("truncating paxos uncommitted metadata in {}", (Object)dataDirectory);
        for (File file : dataDirectory.tryList()) {
            if (file.name().equals("ballot.meta")) continue;
            if (file.isDirectory()) {
                FileUtils.deleteRecursive(file);
                continue;
            }
            FileUtils.deleteWithConfirm(file);
        }
    }

    public static PaxosUncommittedTracker load(File dataDirectory) {
        ImmutableMap.Builder<TableId, UncommittedTableData> builder = ImmutableMap.builder();
        for (TableId tableId : UncommittedTableData.listTableIds(dataDirectory)) {
            builder.put(tableId, UncommittedTableData.load(dataDirectory, tableId));
        }
        return new PaxosUncommittedTracker(dataDirectory, builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    UncommittedTableData getOrCreateTableState(TableId tableId) {
        UncommittedTableData state = this.tableStates.get(tableId);
        if (state == null) {
            PaxosUncommittedTracker paxosUncommittedTracker = this;
            synchronized (paxosUncommittedTracker) {
                state = this.tableStates.get(tableId);
                if (state != null) {
                    return state;
                }
                state = UncommittedTableData.load(this.dataDirectory, tableId);
                this.tableStates = ImmutableMap.builder().putAll(this.tableStates).put(tableId, state).build();
            }
        }
        return state;
    }

    synchronized void flushUpdates(Memtable paxos) throws IOException {
        if (!this.stateFlushEnabled || !this.started) {
            return;
        }
        HashMap<TableId, UncommittedTableData.FlushWriter> flushWriters = new HashMap<TableId, UncommittedTableData.FlushWriter>();
        try (CloseableIterator<PaxosKeyState> iterator = updateSupplier.flushIterator(paxos);){
            while (iterator.hasNext()) {
                PaxosKeyState next = (PaxosKeyState)iterator.next();
                UncommittedTableData.FlushWriter writer = (UncommittedTableData.FlushWriter)flushWriters.get(next.tableId);
                if (writer == null) {
                    writer = this.getOrCreateTableState(next.tableId).flushWriter();
                    flushWriters.put(next.tableId, writer);
                }
                writer.append(next);
            }
        }
        catch (Throwable t2) {
            for (UncommittedTableData.FlushWriter writer : flushWriters.values()) {
                t2 = writer.abort(t2);
            }
            throw new IOException(t2);
        }
        for (UncommittedTableData.FlushWriter writer : flushWriters.values()) {
            writer.finish();
        }
    }

    @VisibleForTesting
    UncommittedTableData getTableState(TableId tableId) {
        return this.tableStates.get(tableId);
    }

    public CloseableIterator<UncommittedPaxosKey> uncommittedKeyIterator(TableId tableId, Collection<Range<Token>> ranges) {
        ranges = ranges == null || ranges.isEmpty() ? Collections.singleton(FULL_RANGE) : Range.normalize(ranges);
        CloseableIterator<PaxosKeyState> updates = updateSupplier.repairIterator(tableId, ranges);
        try {
            UncommittedTableData state = this.tableStates.get(tableId);
            if (state == null) {
                return PaxosKeyState.toUncommittedInfo(updates);
            }
            CloseableIterator<PaxosKeyState> fileIter = state.iterator(ranges);
            try {
                CloseableIterator<PaxosKeyState> merged = PaxosKeyState.mergeUncommitted(updates, fileIter);
                return PaxosKeyState.toUncommittedInfo(merged);
            }
            catch (Throwable t2) {
                fileIter.close();
                throw t2;
            }
        }
        catch (Throwable t3) {
            updates.close();
            throw t3;
        }
    }

    synchronized void truncate() {
        logger.info("truncating paxos uncommitted info");
        this.tableStates.values().forEach(UncommittedTableData::truncate);
        this.tableStates = ImmutableMap.of();
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        logger.info("enabling PaxosUncommittedTracker");
        this.started = true;
    }

    public synchronized void rebuild(Iterator<PaxosKeyState> iterator) throws IOException {
        Preconditions.checkState(!this.started);
        this.truncate();
        HashMap<TableId, UncommittedTableData.FlushWriter> flushWriters = new HashMap<TableId, UncommittedTableData.FlushWriter>();
        try {
            while (iterator.hasNext()) {
                PaxosKeyState next = iterator.next();
                UncommittedTableData.FlushWriter writer = (UncommittedTableData.FlushWriter)flushWriters.get(next.tableId);
                if (writer == null) {
                    writer = this.getOrCreateTableState(next.tableId).rebuildWriter();
                    flushWriters.put(next.tableId, writer);
                }
                writer.append(next);
            }
            for (UncommittedTableData.FlushWriter writer : flushWriters.values()) {
                writer.finish();
            }
        }
        catch (Throwable t2) {
            for (UncommittedTableData.FlushWriter writer : flushWriters.values()) {
                t2 = writer.abort(t2);
            }
            throw new IOException(t2);
        }
        this.start();
    }

    synchronized void consolidateFiles() {
        this.tableStates.values().forEach(UncommittedTableData::maybeScheduleMerge);
    }

    synchronized void schedulePaxosAutoRepairs() {
        if (!DatabaseDescriptor.paxosRepairEnabled() || !this.autoRepairsEnabled) {
            return;
        }
        for (UncommittedTableData tableData : this.tableStates.values()) {
            TableId tableId;
            if (tableData.numFiles() == 0 || SchemaConstants.REPLICATED_SYSTEM_KEYSPACE_NAMES.contains(tableData.keyspace()) || Schema.instance.getTableMetadata(tableId = tableData.tableId()) == null) continue;
            logger.debug("Starting paxos auto repair for {}.{}", (Object)tableData.keyspace(), (Object)tableData.table());
            if (!this.autoRepairTableIds.add(tableId)) {
                logger.debug("Skipping paxos auto repair for {}.{}, another auto repair is already in progress", (Object)tableData.keyspace(), (Object)tableData.table());
                continue;
            }
            StorageService.instance.autoRepairPaxos(tableId).addCallback((success, failure) -> {
                if (failure != null) {
                    logger.error("Paxos auto repair for {}.{} failed", new Object[]{tableData.keyspace(), tableData.table(), failure});
                } else {
                    logger.debug("Paxos auto repair for {}.{} completed", (Object)tableData.keyspace(), (Object)tableData.table());
                }
                this.autoRepairTableIds.remove(tableId);
            });
        }
    }

    private static void runAndLogException(String desc, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t2) {
            logger.error("Unhandled exception running " + desc, t2);
        }
    }

    void maintenance() {
        PaxosUncommittedTracker.runAndLogException("file consolidation", this::consolidateFiles);
        PaxosUncommittedTracker.runAndLogException("schedule auto repairs", this::schedulePaxosAutoRepairs);
        PaxosUncommittedTracker.runAndLogException("evict hung repairs", PaxosRepairState.instance()::evictHungRepairs);
    }

    public synchronized void startAutoRepairs() {
        if (this.autoRepairStarted) {
            return;
        }
        int seconds = CassandraRelevantProperties.AUTO_REPAIR_FREQUENCY_SECONDS.getInt();
        ScheduledExecutors.scheduledTasks.scheduleAtFixedRate(this::maintenance, seconds, seconds, TimeUnit.SECONDS);
        this.autoRepairStarted = true;
    }

    @VisibleForTesting
    public boolean hasInflightAutoRepairs() {
        return !this.autoRepairTableIds.isEmpty();
    }

    public boolean isAutoRepairsEnabled() {
        return this.autoRepairsEnabled;
    }

    public void setAutoRepairsEnabled(boolean autoRepairsEnabled) {
        this.autoRepairsEnabled = autoRepairsEnabled;
    }

    public boolean isStateFlushEnabled() {
        return this.stateFlushEnabled;
    }

    public void setStateFlushEnabled(boolean enabled) {
        this.stateFlushEnabled = enabled;
    }

    public Set<TableId> tableIds() {
        return this.tableStates.keySet();
    }

    public static UpdateSupplier unsafGetUpdateSupplier() {
        return updateSupplier;
    }

    public static void unsafSetUpdateSupplier(UpdateSupplier updateSupplier) {
        Preconditions.checkArgument(updateSupplier != null);
        PaxosUncommittedTracker.updateSupplier = updateSupplier;
    }

    public static interface UpdateSupplier {
        public CloseableIterator<PaxosKeyState> repairIterator(TableId var1, Collection<Range<Token>> var2);

        public CloseableIterator<PaxosKeyState> flushIterator(Memtable var1);
    }
}

