/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.util.BufferRecyclers;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileInputStreamPlus;
import org.apache.cassandra.io.util.FileOutputStreamPlus;
import org.apache.cassandra.serializers.MarshalException;

public final class JsonUtils {
    public static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper(new JsonFactory());
    public static final ObjectWriter JSON_OBJECT_PRETTY_WRITER;

    private JsonUtils() {
    }

    public static String quoteAsJsonString(String s2) {
        return new String(BufferRecyclers.getJsonStringEncoder().quoteAsString(s2));
    }

    public static Object decodeJson(byte[] json) {
        try {
            return JSON_OBJECT_MAPPER.readValue(json, Object.class);
        }
        catch (IOException ex) {
            throw new MarshalException("Error decoding JSON bytes: " + ex.getMessage());
        }
    }

    public static Object decodeJson(String json) {
        try {
            return JSON_OBJECT_MAPPER.readValue(json, Object.class);
        }
        catch (IOException ex) {
            throw new MarshalException("Error decoding JSON string: " + ex.getMessage());
        }
    }

    public static byte[] writeAsJsonBytes(Object value) {
        try {
            return JSON_OBJECT_MAPPER.writeValueAsBytes(value);
        }
        catch (IOException ex) {
            throw new MarshalException("Error writing as JSON: " + ex.getMessage());
        }
    }

    public static String writeAsJsonString(Object value) {
        try {
            return JSON_OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (IOException ex) {
            throw new MarshalException("Error writing as JSON: " + ex.getMessage());
        }
    }

    public static String writeAsPrettyJsonString(Object value) throws MarshalException {
        try {
            return JSON_OBJECT_PRETTY_WRITER.writeValueAsString(value);
        }
        catch (IOException ex) {
            throw new MarshalException("Error writing as JSON: " + ex.getMessage());
        }
    }

    public static <T> Map<String, T> fromJsonMap(String json) {
        try {
            return (Map)JSON_OBJECT_MAPPER.readValue(json, Map.class);
        }
        catch (IOException ex) {
            throw new MarshalException("Error decoding JSON string: " + ex.getMessage());
        }
    }

    public static <T> Map<String, T> fromJsonMap(byte[] bytes) {
        try {
            return (Map)JSON_OBJECT_MAPPER.readValue(bytes, Map.class);
        }
        catch (IOException ex) {
            throw new MarshalException("Error decoding JSON: " + ex.getMessage());
        }
    }

    public static List<String> fromJsonList(byte[] bytes) {
        try {
            return (List)JSON_OBJECT_MAPPER.readValue(bytes, List.class);
        }
        catch (IOException ex) {
            throw new MarshalException("Error decoding JSON: " + ex.getMessage());
        }
    }

    public static List<String> fromJsonList(String json) {
        try {
            return (List)JSON_OBJECT_MAPPER.readValue(json, List.class);
        }
        catch (IOException ex) {
            throw new MarshalException("Error decoding JSON: " + ex.getMessage());
        }
    }

    public static void serializeToJsonFile(Object object, File outputFile) throws IOException {
        try (FileOutputStreamPlus out = outputFile.newOutputStream(File.WriteMode.OVERWRITE);){
            JSON_OBJECT_PRETTY_WRITER.writeValue((OutputStream)out, object);
        }
    }

    public static <T> T deserializeFromJsonFile(Class<T> tClass, File file) throws IOException {
        try (FileInputStreamPlus in = file.newInputStream();){
            Object object = JSON_OBJECT_MAPPER.readValue((InputStream)in, tClass);
            return (T)object;
        }
    }

    public static void handleCaseSensitivity(Map<String, Object> valueMap) {
        for (String mapKey : new ArrayList<String>(valueMap.keySet())) {
            if (mapKey.startsWith("\"") && mapKey.endsWith("\"")) {
                valueMap.put(mapKey.substring(1, mapKey.length() - 1), valueMap.remove(mapKey));
                continue;
            }
            String lowered = mapKey.toLowerCase(Locale.US);
            if (mapKey.equals(lowered)) continue;
            valueMap.put(lowered, valueMap.remove(mapKey));
        }
    }

    static {
        JSON_OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        JSON_OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        JSON_OBJECT_PRETTY_WRITER = JSON_OBJECT_MAPPER.writerWithDefaultPrettyPrinter();
    }
}

