/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.bytecomparable;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public final class ByteSourceInverse {
    private static final int INITIAL_BUFFER_CAPACITY = 32;
    private static final int BYTE_ALL_BITS = 255;
    private static final int BYTE_NO_BITS = 0;
    private static final int BYTE_SIGN_BIT = 128;
    private static final int SHORT_SIGN_BIT = 32768;
    private static final int INT_SIGN_BIT = Integer.MIN_VALUE;
    private static final long LONG_SIGN_BIT = Long.MIN_VALUE;

    public static long getUnsignedFixedLengthAsLong(ByteSource byteSource, int length) {
        Preconditions.checkNotNull(byteSource);
        Preconditions.checkArgument(length >= 1 && length <= 8, "Between 1 and 8 bytes can be read at a time");
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result = result << 8 | (long)ByteSourceInverse.getAndCheckByte(byteSource, i, length);
        }
        return result;
    }

    public static <V> V getSignedFixedLength(ValueAccessor<V> accessor, ByteSource byteSource, int length) {
        Preconditions.checkNotNull(byteSource);
        Preconditions.checkArgument(length >= 1, "At least 1 byte should be read");
        V result = accessor.allocate(length);
        accessor.putByte(result, 0, (byte)(ByteSourceInverse.getAndCheckByte(byteSource, 0, length) ^ 0x80));
        for (int i = 1; i < length; ++i) {
            accessor.putByte(result, i, (byte)ByteSourceInverse.getAndCheckByte(byteSource, i, length));
        }
        return result;
    }

    public static <V> V getOptionalSignedFixedLength(ValueAccessor<V> accessor, ByteSource byteSource, int length) {
        return byteSource == null ? accessor.empty() : ByteSourceInverse.getSignedFixedLength(accessor, byteSource, length);
    }

    public static <V> V getSignedFixedLengthFloat(ValueAccessor<V> accessor, ByteSource byteSource, int length) {
        int xor;
        Preconditions.checkNotNull(byteSource);
        Preconditions.checkArgument(length >= 1, "At least 1 byte should be read");
        V result = accessor.allocate(length);
        int first = ByteSourceInverse.getAndCheckByte(byteSource, 0, length);
        if (first < 128) {
            xor = 255;
            first ^= xor;
        } else {
            xor = 0;
            first ^= 0x80;
        }
        accessor.putByte(result, 0, (byte)first);
        for (int i = 1; i < length; ++i) {
            accessor.putByte(result, i, (byte)(ByteSourceInverse.getAndCheckByte(byteSource, i, length) ^ xor));
        }
        return result;
    }

    public static <V> V getOptionalSignedFixedLengthFloat(ValueAccessor<V> accessor, ByteSource byteSource, int length) {
        return byteSource == null ? accessor.empty() : ByteSourceInverse.getSignedFixedLengthFloat(accessor, byteSource, length);
    }

    public static <V> V getFixedLength(ValueAccessor<V> accessor, ByteSource byteSource, int length) {
        Preconditions.checkNotNull(byteSource);
        Preconditions.checkArgument(length >= 1, "At least 1 byte should be read");
        V result = accessor.allocate(length);
        for (int i = 0; i < length; ++i) {
            accessor.putByte(result, i, (byte)ByteSourceInverse.getAndCheckByte(byteSource, i, length));
        }
        return result;
    }

    public static <V> V getOptionalFixedLength(ValueAccessor<V> accessor, ByteSource byteSource, int length) {
        return byteSource == null ? accessor.empty() : ByteSourceInverse.getFixedLength(accessor, byteSource, length);
    }

    public static int getSignedInt(ByteSource byteSource) {
        return (int)ByteSourceInverse.getUnsignedFixedLengthAsLong(byteSource, 4) ^ Integer.MIN_VALUE;
    }

    public static long getSignedLong(ByteSource byteSource) {
        return ByteSourceInverse.getUnsignedFixedLengthAsLong(byteSource, 8) ^ Long.MIN_VALUE;
    }

    public static byte getSignedByte(ByteSource byteSource) {
        return (byte)(ByteSourceInverse.getAndCheckByte(Preconditions.checkNotNull(byteSource), 0, 1) ^ 0x80);
    }

    public static short getSignedShort(ByteSource byteSource) {
        return (short)(ByteSourceInverse.getUnsignedFixedLengthAsLong(byteSource, 2) ^ 0x8000L);
    }

    public static long getVariableLengthInteger(ByteSource byteSource) {
        int bytes;
        int signAndMask = ByteSourceInverse.getAndCheckByte(byteSource);
        long sum = 0L;
        for (bytes = 0; bytes < 7 && ByteSourceInverse.sameByteSign(signAndMask << bytes + 1, signAndMask); ++bytes) {
            sum = sum << 8 | (long)ByteSourceInverse.getAndCheckByte(byteSource);
        }
        if (bytes == 7 && ByteSourceInverse.sameByteSign((int)(sum >> 48), signAndMask)) {
            return (sum << 8 | (long)ByteSourceInverse.getAndCheckByte(byteSource)) ^ Long.MIN_VALUE;
        }
        long signMask = -64L << bytes * 7;
        long sign = (byte)(signAndMask ^ 0x80) >> 7;
        return (sum |= (long)signAndMask << bytes * 8) & (signMask ^ 0xFFFFFFFFFFFFFFFFL) | sign & signMask;
    }

    public static long getVariableLengthUnsignedIntegerXoring(ByteSource byteSource, int xorWith) {
        int bytes;
        int signAndMask = ByteSourceInverse.getAndCheckByte(byteSource) ^ xorWith;
        long sum = 0L;
        for (bytes = 0; bytes <= 7 && (signAndMask << bytes & 0x80) != 0; ++bytes) {
            sum = sum << 8 | (long)(ByteSourceInverse.getAndCheckByte(byteSource) ^ xorWith);
        }
        return sum | (long)(signAndMask &= ~(-256 >> bytes)) << bytes * 8;
    }

    private static boolean sameByteSign(int a, int b) {
        return ((a ^ b) & 0x80) == 0;
    }

    private static int getAndCheckByte(ByteSource byteSource) {
        return ByteSourceInverse.getAndCheckByte(byteSource, -1, -1);
    }

    private static int getAndCheckByte(ByteSource byteSource, int pos, int length) {
        int data = byteSource.next();
        if (data == -1) {
            throw new IllegalArgumentException(length > 0 ? String.format("Unexpected end of stream reached after %d bytes (expected >= %d)", pos, length) : "Unexpected end of stream");
        }
        assert (data >= 0 && data <= 255) : "A ByteSource must produce unsigned bytes and end in END_OF_STREAM";
        return data;
    }

    public static byte[] getUnescapedBytes(ByteSource.Peekable byteSource) {
        return byteSource == null ? null : ByteSourceInverse.readBytes(ByteSourceInverse.unescape(byteSource));
    }

    public static ByteSource unescape(final ByteSource.Peekable byteSource) {
        return new ByteSource(){
            boolean escaped = false;

            @Override
            public int next() {
                if (!this.escaped) {
                    int data = byteSource.next();
                    if (data > 0) {
                        return data;
                    }
                    assert (data != -1) : "Invalid escaped byte sequence";
                    this.escaped = true;
                }
                int next = byteSource.peek();
                switch (next) {
                    case -1: {
                        byteSource.next();
                        return -1;
                    }
                    case 255: {
                        this.escaped = false;
                        byteSource.next();
                        return 0;
                    }
                    case 254: {
                        byteSource.next();
                        return 0;
                    }
                }
                assert (next >= 16 && next <= 239) : next;
                return -1;
            }
        };
    }

    public static byte[] readBytes(ByteSource byteSource, int initialBufferCapacity) {
        int data;
        Preconditions.checkNotNull(byteSource);
        int readBytes = 0;
        byte[] buf = new byte[initialBufferCapacity];
        while ((data = byteSource.next()) != -1) {
            buf = ByteSourceInverse.ensureCapacity(buf, readBytes);
            buf[readBytes++] = (byte)data;
        }
        if (readBytes != buf.length) {
            buf = Arrays.copyOf(buf, readBytes);
        }
        return buf;
    }

    public static byte[] readBytes(ByteSource byteSource) {
        return ByteSourceInverse.readBytes(byteSource, 32);
    }

    public static void copyBytes(ByteSource byteSource, byte[] bytes) {
        int data;
        int readBytes = 0;
        while ((data = byteSource.next()) != -1) {
            if (bytes.length == readBytes) {
                throw new ArrayIndexOutOfBoundsException(String.format("Number of bytes read, %d, exceeds the buffer size of %d.", readBytes + 1, bytes.length));
            }
            bytes[readBytes++] = (byte)data;
        }
    }

    private static byte[] ensureCapacity(byte[] buf, int dataLengthInBytes) {
        if (dataLengthInBytes == buf.length) {
            return Arrays.copyOf(buf, dataLengthInBytes * 2);
        }
        return buf;
    }

    public static String getString(ByteSource.Peekable byteSource) {
        if (byteSource == null) {
            return null;
        }
        byte[] data = ByteSourceInverse.getUnescapedBytes(byteSource);
        return new String(data, StandardCharsets.UTF_8);
    }

    public static ByteSource.Peekable nextComponentSource(ByteSource.Peekable source) {
        return ByteSourceInverse.nextComponentSource(source, source.next());
    }

    public static ByteSource.Peekable nextComponentSource(ByteSource.Peekable source, int separator) {
        return ByteSourceInverse.nextComponentNull(separator) ? null : source;
    }

    public static boolean nextComponentNull(int separator) {
        return separator == 62 || separator == 63 || separator == 65;
    }
}

