/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

class SliceExecutor {
    private final Executor executor;

    SliceExecutor(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "Executor is null");
    }

    final void invokeAll(Collection<? extends Runnable> tasks) {
        int i = 0;
        for (Runnable runnable : tasks) {
            if (this.shouldExecuteOnCallerThread(i, tasks.size())) {
                runnable.run();
            } else {
                try {
                    this.executor.execute(runnable);
                }
                catch (RejectedExecutionException e) {
                    runnable.run();
                }
            }
            ++i;
        }
    }

    boolean shouldExecuteOnCallerThread(int index, int numTasks) {
        return index == numTasks - 1;
    }
}

