/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.apache.cassandra.spark.bulkwriter.AbstractBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.BulkWriterConfig;
import org.apache.cassandra.spark.bulkwriter.CassandraClusterInfo;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;

public class CassandraBulkWriterContext
extends AbstractBulkWriterContext {
    protected CassandraBulkWriterContext(@NotNull BulkSparkConf conf, @NotNull StructType structType, int sparkDefaultParallelism) {
        super(conf, structType, sparkDefaultParallelism);
    }

    protected CassandraBulkWriterContext(@NotNull BulkWriterConfig config) {
        super(config);
    }

    @Override
    protected ClusterInfo buildClusterInfo() {
        return new CassandraClusterInfo(this.bulkSparkConf());
    }

    @Override
    protected void validateKeyspaceReplication() {
        BulkSparkConf conf = this.bulkSparkConf();
        if (!conf.consistencyLevel.isLocal()) {
            return;
        }
        boolean isReplicatedToLocalDc = !StringUtils.isEmpty((CharSequence)conf.localDC) && this.cluster().replicationFactor().getOptions().containsKey(conf.localDC);
        Preconditions.checkState((boolean)isReplicatedToLocalDc, (String)"Keyspace %s is not replicated on datacenter %s", (Object[])new Object[]{conf.keyspace, conf.localDC});
    }

    @Override
    protected MultiClusterContainer<UUID> generateRestoreJobIds() {
        return MultiClusterContainer.ofSingle(this.bridge().getTimeUUID());
    }
}

